/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.combobox.sinks;

import com.basis.bbj.proxies.event.BBjListSelectEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.combobox.ComboBox;
import org.dwcj.controls.combobox.events.ComboBoxSelectEvent;

public final class ComboBoxSelectEventSink {
    private ArrayList<Consumer<ComboBoxSelectEvent>> targets = new ArrayList();
    private final ComboBox comboBox;
    private BBjControl bbjctrl;

    public ComboBoxSelectEventSink(ComboBox cb) {
        this.comboBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(22, Environment.getInstance().getDwcjHelper().getEventProxy(this, "selectEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ComboBoxSelectEventSink(ComboBox cb, Consumer<ComboBoxSelectEvent> callback) {
        this.targets.add(callback);
        this.comboBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(22, Environment.getInstance().getDwcjHelper().getEventProxy(this, "selectEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void selectEvent(BBjListSelectEvent ev) {
        ComboBoxSelectEvent dwcEv = new ComboBoxSelectEvent(this.comboBox);
        Iterator<Consumer<ComboBoxSelectEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void doSelect(Object key) {
        ComboBoxSelectEvent dwcEv = new ComboBoxSelectEvent(this.comboBox);
        dwcEv.setKey(key);
        Iterator<Consumer<ComboBoxSelectEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<ComboBoxSelectEvent> callback) {
        this.targets.add(callback);
    }
}

