/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.htmlcontainer;

import com.basis.bbj.proxies.sysgui.BBjHtmlView;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.awt.Image;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.htmlcontainer.events.HtmlContainerJavascriptEvent;
import org.dwcj.controls.htmlcontainer.events.HtmlContainerOnScriptFailedEvent;
import org.dwcj.controls.htmlcontainer.events.HtmlContainerOnScriptLoadedEvent;
import org.dwcj.controls.htmlcontainer.events.HtmlContainerPageLoadedEvent;
import org.dwcj.controls.htmlcontainer.sinks.HtmlContainerNativeJavascriptEventSink;
import org.dwcj.controls.htmlcontainer.sinks.HtmlContainerOnScriptFailedEventSink;
import org.dwcj.controls.htmlcontainer.sinks.HtmlContainerOnScriptLoadedEventSink;
import org.dwcj.controls.htmlcontainer.sinks.HtmlContainerPageLoadedEventSink;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.util.BBjFunctionalityHelper;

public final class HtmlContainer
extends AbstractDwcControl
implements Focusable,
TabTraversable {
    private BBjHtmlView bbjHtmlView;
    private final ArrayList<Consumer<HtmlContainerOnScriptLoadedEvent>> scriptLoadedEvents = new ArrayList();
    private HtmlContainerOnScriptLoadedEventSink onScriptLoadedSink = null;
    private final ArrayList<Consumer<HtmlContainerOnScriptFailedEvent>> scriptFailedEvents = new ArrayList();
    private HtmlContainerOnScriptFailedEventSink onScriptFailedSink = null;
    private final ArrayList<Consumer<HtmlContainerJavascriptEvent>> javascriptEvents = new ArrayList();
    private HtmlContainerNativeJavascriptEventSink javascriptEventSink = null;
    private final ArrayList<Consumer<HtmlContainerPageLoadedEvent>> pageLoadedEvents = new ArrayList();
    private HtmlContainerPageLoadedEventSink pageLoadedEventSink = null;
    private String asyncScript = "";
    private String executeScript = "";
    private String injectScript = "";
    private Boolean injectScriptTop = false;
    private String injectURL = "";
    private Boolean injectURLTop = false;
    private Boolean autoNavigate = false;
    private String downloadDirectory = "";
    private String url = "";
    private Boolean reload = false;
    private String userAgent = "";

    public HtmlContainer() {
    }

    public HtmlContainer(String text) {
        this.setText(text);
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addHtmlView(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, this.getText(), flags);
            this.ctrl.setNoEdge(true);
            this.bbjHtmlView = (BBjHtmlView)this.ctrl;
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public HtmlContainer onScriptLoaded(Consumer<HtmlContainerOnScriptLoadedEvent> callback) {
        if (this.ctrl != null) {
            if (this.onScriptLoadedSink == null) {
                this.onScriptLoadedSink = new HtmlContainerOnScriptLoadedEventSink(this);
            }
            this.onScriptLoadedSink.addCallback(callback);
        } else {
            this.scriptLoadedEvents.add(callback);
        }
        return this;
    }

    public HtmlContainer onScriptFailed(Consumer<HtmlContainerOnScriptFailedEvent> callback) {
        if (this.ctrl != null) {
            if (this.onScriptFailedSink == null) {
                this.onScriptFailedSink = new HtmlContainerOnScriptFailedEventSink(this);
            }
            this.onScriptFailedSink.addCallback(callback);
        } else {
            this.scriptFailedEvents.add(callback);
        }
        return this;
    }

    public void executeAsyncScript(String script) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.executeAsyncScript(script);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.asyncScript = script;
    }

    public Object executeScript(String script) {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.executeScript(script);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.executeScript = script;
        return null;
    }

    public Boolean isAutoNavigate() {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.getAutoNavigate();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.autoNavigate;
    }

    public String getClientType() {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.getClientType();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public String getClientVersion() {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.getClientVersion();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public Image getImage() {
        if (this.ctrl != null) {
            try {
                return (Image)this.bbjHtmlView.getImage();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    @Override
    public String getText() {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.getText();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return super.getText();
    }

    public String getUrl() {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.getUrl();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.url;
    }

    public String getUserAgent() {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.getUserAgent();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.userAgent;
    }

    public HtmlContainer injectScript(String script) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.injectScript(script);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.injectScript = script;
        return this;
    }

    public HtmlContainer injectScript(String script, Boolean top) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.injectScript(script, top.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.injectScript = script;
        this.injectScriptTop = top;
        return this;
    }

    public HtmlContainer injectUrl(String url) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.injectUrl(url);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.injectURL = url;
        return this;
    }

    public HtmlContainer injectUrl(String url, Boolean top) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.injectUrl(url, top.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.injectURL = url;
        this.injectURLTop = top;
        return this;
    }

    public Boolean print() {
        if (this.ctrl != null) {
            try {
                return this.bbjHtmlView.print();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public HtmlContainer setAutoNavigate(Boolean autoNavigate) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.setAutoNavigate(autoNavigate.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.autoNavigate = autoNavigate;
        return this;
    }

    public HtmlContainer setDownloadDirectory(String downloadDir) {
        if (this.ctrl != null) {
            this.bbjHtmlView.setDownloadDirectory(downloadDir);
        }
        this.downloadDirectory = downloadDir;
        return this;
    }

    public HtmlContainer setUrl(String url) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.setUrl(url);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.url = url;
        return this;
    }

    public HtmlContainer setUrl(String url, Boolean reload) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.setUrl(url, reload.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.url = url;
        this.reload = reload;
        return this;
    }

    public HtmlContainer setUserAgent(String userAgent) {
        if (this.ctrl != null) {
            this.bbjHtmlView.setUserAgent(userAgent);
        }
        return this;
    }

    public HtmlContainer onPageLoaded(Consumer<HtmlContainerPageLoadedEvent> callback) {
        if (this.ctrl != null) {
            if (this.pageLoadedEventSink == null) {
                this.pageLoadedEventSink = new HtmlContainerPageLoadedEventSink(this);
            }
            this.pageLoadedEventSink.addCallback(callback);
        } else {
            this.pageLoadedEvents.add(callback);
        }
        return this;
    }

    public HtmlContainer onJavascriptEvent(Consumer<HtmlContainerJavascriptEvent> callback) {
        if (this.ctrl != null) {
            if (this.javascriptEventSink == null) {
                this.javascriptEventSink = new HtmlContainerNativeJavascriptEventSink(this);
            }
            this.javascriptEventSink.addCallback(callback);
        } else {
            this.javascriptEvents.add(callback);
        }
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public HtmlContainer setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public HtmlContainer setTabTraversable(Boolean traversable) {
        if (this.ctrl != null) {
            try {
                this.bbjHtmlView.setTabTraversable(traversable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traversable;
        return this;
    }

    @Override
    public HtmlContainer setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public HtmlContainer setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public HtmlContainer setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public HtmlContainer setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public HtmlContainer setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public HtmlContainer setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public HtmlContainer setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public HtmlContainer addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public HtmlContainer removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (!this.scriptLoadedEvents.isEmpty()) {
            this.onScriptLoadedSink = new HtmlContainerOnScriptLoadedEventSink(this);
            while (!this.scriptLoadedEvents.isEmpty()) {
                this.onScriptLoadedSink.addCallback(this.scriptLoadedEvents.remove(0));
            }
        }
        if (!this.scriptFailedEvents.isEmpty()) {
            this.onScriptFailedSink = new HtmlContainerOnScriptFailedEventSink(this);
            while (!this.scriptFailedEvents.isEmpty()) {
                this.onScriptFailedSink.addCallback(this.scriptFailedEvents.remove(0));
            }
        }
        if (!this.javascriptEvents.isEmpty()) {
            this.javascriptEventSink = new HtmlContainerNativeJavascriptEventSink(this);
            while (!this.javascriptEvents.isEmpty()) {
                this.javascriptEventSink.addCallback(this.javascriptEvents.remove(0));
            }
        }
        if (!this.pageLoadedEvents.isEmpty()) {
            this.pageLoadedEventSink = new HtmlContainerPageLoadedEventSink(this);
            while (!this.pageLoadedEvents.isEmpty()) {
                this.pageLoadedEventSink.addCallback(this.pageLoadedEvents.remove(0));
            }
        }
        if (!this.asyncScript.equals("")) {
            this.executeAsyncScript(this.asyncScript);
        }
        if (!this.executeScript.equals("")) {
            this.executeScript(this.executeScript);
        }
        if (!this.injectScript.equals("")) {
            this.injectScript(this.injectScript, this.injectScriptTop);
        }
        if (!this.injectURL.equals("")) {
            this.injectUrl(this.injectURL, this.injectURLTop);
        }
        if (Boolean.TRUE.equals(this.autoNavigate)) {
            this.setAutoNavigate(this.autoNavigate);
        }
        if (!this.downloadDirectory.equals("")) {
            this.setDownloadDirectory(this.downloadDirectory);
        }
        if (!this.url.equals("")) {
            this.setUrl(this.url, this.reload);
        }
        if (!this.userAgent.equals("")) {
            this.setUserAgent(this.userAgent);
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
    }
}

