/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.listbox;

import com.basis.bbj.proxies.sysgui.BBjListBox;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.listbox.AbstractDwclistControl;
import org.dwcj.controls.listbox.events.ListBoxDoubleClickEvent;
import org.dwcj.controls.listbox.events.ListBoxSelectEvent;
import org.dwcj.controls.listbox.sinks.ListBoxDoubleClickEventSink;
import org.dwcj.controls.listbox.sinks.ListBoxSelectEventSink;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.HasMouseWheelCondition;
import org.dwcj.interfaces.HasReadOnly;
import org.dwcj.interfaces.Scrollable;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.interfaces.TextAlignable;
import org.dwcj.util.BBjFunctionalityHelper;

public final class ListBox
extends AbstractDwclistControl
implements Scrollable,
HasReadOnly,
Focusable,
HasMouseWheelCondition,
TabTraversable,
TextAlignable {
    private BBjListBox bbjListBox;
    private ArrayList<Consumer<ListBoxSelectEvent>> selectEvents = new ArrayList();
    private ListBoxSelectEventSink selectEventSink;
    private ArrayList<Consumer<ListBoxDoubleClickEvent>> doubleClickEvents = new ArrayList();
    private ListBoxDoubleClickEventSink doubleClickEventSink;
    Boolean multipleSelection = false;
    private AbstractMap.SimpleEntry<Integer, String> textAt = null;

    public ListBox() {
        this.horizontalScrollBarPosition = 0;
        this.verticalScrollBarPosition = 0;
        this.readOnly = false;
        this.focusable = true;
        this.mouseWheelCondition = HasMouseWheelCondition.MouseWheelCondition.DEFAULT;
        this.tabTraversable = true;
        this.textAlignment = TextAlignable.Alignment.LEFT;
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addListBox(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_250, (BBjNumber)BASISNUMBER_250, "", flags);
            this.ctrl.setAttribute("max-row-count", "25");
            this.ctrl.setAttribute("open-width", "2500");
            this.ctrl.setAttribute("button-height", "auto");
            this.bbjListBox = (BBjListBox)this.ctrl;
            this.populate();
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ListBox addItem(Object key, String item) {
        this.values.put(key, item);
        this.data2.add(this.values.get(key));
        this.populate();
        return this;
    }

    public ListBox insertItemAt(Object key, String item, Integer index) {
        this.values.put(key, item);
        this.data2.add(index.intValue(), this.values.get(key));
        this.populate();
        return this;
    }

    public ListBox addItems(Map<Object, String> items) {
        this.values.putAll(items);
        Iterator<Object> it = items.keySet().iterator();
        while (it.hasNext()) {
            this.data2.add(this.values.get(it.next()));
        }
        this.populate();
        return this;
    }

    public ListBox insertItemsAt(Map<Object, String> items, Integer index) {
        this.values.putAll(items);
        Iterator<Object> it = items.keySet().iterator();
        Integer counter = 0;
        while (it.hasNext()) {
            Integer n = counter;
            counter = counter + 1;
            this.data2.add(index + n, this.values.get(it.next()));
        }
        this.populate();
        return this;
    }

    @Override
    protected void populate() {
        if (this.ctrl != null) {
            try {
                BBjListBox cb = (BBjListBox)this.ctrl;
                cb.removeAllItems();
                cb.insertItems(0, this.data2);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
    }

    public ListBox deselectAll() {
        if (this.ctrl != null) {
            try {
                this.bbjListBox.deselectAll();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ListBox deselectIndex(int index) {
        if (this.ctrl != null) {
            try {
                this.bbjListBox.deselectIndex(index);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public Map<Object, String> getAllItems() {
        if (this.ctrl != null) {
            return this.values;
        }
        return Collections.emptyMap();
    }

    public String getItem(Object key) {
        if (this.ctrl != null) {
            return (String)this.values.get(key);
        }
        return null;
    }

    public String getItemAt(Integer idx) {
        if (this.ctrl != null) {
            try {
                BBjListBox cb = (BBjListBox)this.ctrl;
                return cb.getItemAt(idx.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public Integer getItemCount() {
        if (this.ctrl != null) {
            try {
                this.bbjListBox.getItemCount();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public Boolean isMultipleSelection() {
        if (this.ctrl != null) {
            try {
                return this.bbjListBox.getMultipleSelection();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public AbstractMap.SimpleEntry<Object, String> getSelectedItem() {
        if (this.ctrl != null) {
            try {
                String value = this.bbjListBox.getSelectedItem();
                return new AbstractMap.SimpleEntry<Object, String>(this.getEntryByValue(value), value);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public AbstractMap.SimpleEntry<Object, String> getEntryByValue(String value) {
        if (this.ctrl != null) {
            Map map = this.values;
            for (Map.Entry entry : map.entrySet()) {
                if (!Objects.equals(value, entry.getValue())) continue;
                return new AbstractMap.SimpleEntry<Object, String>(entry.getKey(), value);
            }
        }
        return null;
    }

    public Map<Object, String> getSelectedItems() {
        if (this.ctrl != null) {
            HashMap<Object, String> map = new HashMap<Object, String>();
            try {
                Object[] indices;
                for (Object index : indices = this.bbjListBox.getSelectedIndices().toArray()) {
                    Object key;
                    String value = this.bbjListBox.getItemAt(((Integer)index).intValue());
                    AbstractMap.SimpleEntry<Object, String> entry = this.getEntryByValue(value);
                    if (entry == null || (key = entry.getKey()) == null) continue;
                    map.put(key, value);
                }
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public ListBox setItems(Map<Object, String> values) {
        this.values = values;
        this.data2.clear();
        Iterator<Object> it = values.keySet().iterator();
        while (it.hasNext()) {
            this.data2.add((Object)values.get(it.next()));
        }
        this.populate();
        return this;
    }

    public ListBox onSelect(Consumer<ListBoxSelectEvent> callback) {
        if (this.ctrl != null) {
            if (this.selectEventSink == null) {
                this.selectEventSink = new ListBoxSelectEventSink(this);
            }
            this.selectEventSink.addCallback(callback);
        } else {
            this.selectEvents.add(callback);
        }
        return this;
    }

    public ListBox onDoubleClick(Consumer<ListBoxDoubleClickEvent> callback) {
        if (this.ctrl != null) {
            if (this.doubleClickEventSink == null) {
                this.doubleClickEventSink = new ListBoxDoubleClickEventSink(this);
            }
            this.doubleClickEventSink.addCallback(callback);
        } else {
            this.doubleClickEvents.add(callback);
        }
        return this;
    }

    public ListBox removeAllItems() {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).removeAllItems();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ListBox removeItemAt(Integer idx) {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).removeItemAt(idx.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ListBox selectIndex(Integer idx) {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).selectIndex(idx.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ListBox setMultipleSelection(Boolean multipleSelection) {
        if (this.ctrl != null) {
            try {
                this.bbjListBox.setMultipleSelection(multipleSelection.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.multipleSelection = multipleSelection;
        return this;
    }

    public ListBox setTextAt(Integer idx, String text) {
        this.textAt = new AbstractMap.SimpleEntry<Integer, String>(idx, text);
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).setTextAt(idx.intValue(), text);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    @Override
    public ListBox setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public ListBox setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public ListBox setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public ListBox setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public ListBox setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public ListBox setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public ListBox setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public ListBox addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public ListBox removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public ListBox setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    @Override
    public Integer getHorizontalScrollBarHeight() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).getHorizontalScrollBarHeight();
        }
        return 0;
    }

    @Override
    public Integer getHorizontalScrollBarPosition() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).getHorizontalScrollBarPosition();
        }
        return this.horizontalScrollBarPosition;
    }

    @Override
    public Integer getHorizontalScrollBarWidth() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).getHorizontalScrollBarWidth();
        }
        return 0;
    }

    @Override
    public Integer getVerticalScrollBarHeight() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).getVerticalScrollBarHeight();
        }
        return 0;
    }

    @Override
    public Integer getVerticalScrollBarPosition() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).getVerticalScrollBarPosition();
        }
        return this.verticalScrollBarPosition;
    }

    @Override
    public Integer getVerticalScrollBarWidth() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).getVerticalScrollBarWidth();
        }
        return 0;
    }

    @Override
    public Boolean isHorizontalScrollBarVisible() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).isHorizontalScrollBarVisible();
        }
        return false;
    }

    @Override
    public Boolean isVerticalScrollBarVisible() {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).isVerticalScrollBarVisible();
        }
        return false;
    }

    @Override
    public ListBox setHorizontalScrollBarPosition(Integer position) {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).setHorizontalScrollBarPosition(position.intValue());
        }
        this.horizontalScrollBarPosition = position;
        return this;
    }

    @Override
    public ListBox setVerticalScrollBarPosition(Integer position) {
        if (this.ctrl != null) {
            ((BBjListBox)this.ctrl).setVerticalScrollBarPosition(position.intValue());
        }
        this.verticalScrollBarPosition = position;
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        if (this.ctrl != null) {
            try {
                return !((BBjListBox)this.ctrl).isEditable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.readOnly;
    }

    @Override
    public ListBox setReadOnly(Boolean editable) {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).setEditable(editable == false);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
            return this;
        }
        this.readOnly = editable;
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                return ((BBjListBox)this.ctrl).isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public ListBox setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public HasMouseWheelCondition.MouseWheelCondition getScrollWheelBehavior() {
        return this.mouseWheelCondition;
    }

    @Override
    public ListBox setScrollWheelBehavior(HasMouseWheelCondition.MouseWheelCondition condition) {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).setScrollWheelBehavior(condition.mouseWheelEnabledCondition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.mouseWheelCondition = condition;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                return ((BBjListBox)this.ctrl).isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public ListBox setTabTraversable(Boolean traversable) {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).setTabTraversable(traversable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traversable;
        return this;
    }

    @Override
    public TextAlignable.Alignment getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public ListBox setTextAlignment(TextAlignable.Alignment alignment) {
        if (this.ctrl != null) {
            try {
                ((BBjListBox)this.ctrl).setAlignment(alignment.textPosition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.textAlignment = alignment;
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (!this.selectEvents.isEmpty()) {
            this.selectEventSink = new ListBoxSelectEventSink(this);
            while (!this.selectEvents.isEmpty()) {
                this.selectEventSink.addCallback(this.selectEvents.remove(0));
            }
        }
        if (!this.doubleClickEvents.isEmpty()) {
            this.doubleClickEventSink = new ListBoxDoubleClickEventSink(this);
            while (!this.doubleClickEvents.isEmpty()) {
                this.doubleClickEventSink.addCallback(this.doubleClickEvents.remove(0));
            }
        }
        if (Boolean.TRUE.equals(this.multipleSelection)) {
            this.setMultipleSelection(this.multipleSelection);
        }
        if (this.textAt != null) {
            this.setTextAt(this.textAt.getKey(), this.textAt.getValue());
        }
        if (this.horizontalScrollBarPosition != 0) {
            this.setHorizontalScrollBarPosition(this.horizontalScrollBarPosition);
        }
        if (this.verticalScrollBarPosition != 0) {
            this.setVerticalScrollBarPosition(this.horizontalScrollBarPosition);
        }
        if (Boolean.TRUE.equals(this.readOnly)) {
            this.setReadOnly(this.readOnly);
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (this.mouseWheelCondition != HasMouseWheelCondition.MouseWheelCondition.DEFAULT) {
            this.setScrollWheelBehavior(this.mouseWheelCondition);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
        if (this.textAlignment != TextAlignable.Alignment.LEFT) {
            this.setTextAlignment(this.textAlignment);
        }
    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }
}

