/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.listbox.sinks;

import com.basis.bbj.proxies.event.BBjListDoubleClickEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.listbox.ListBox;
import org.dwcj.controls.listbox.events.ListBoxDoubleClickEvent;

public class ListBoxDoubleClickEventSink {
    private final ArrayList<Consumer<ListBoxDoubleClickEvent>> targets = new ArrayList();
    private final ListBox listBox;

    public ListBoxDoubleClickEventSink(ListBox listBox) {
        this.listBox = listBox;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(listBox);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(19, Environment.getInstance().getDwcjHelper().getEventProxy(this, "doubleClickEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ListBoxDoubleClickEventSink(ListBox listBox, Consumer<ListBoxDoubleClickEvent> callback) {
        this.targets.add(callback);
        this.listBox = listBox;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(listBox);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(19, Environment.getInstance().getDwcjHelper().getEventProxy(this, "doubleClickEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void doubleClickEvent(BBjListDoubleClickEvent ev) {
        ListBoxDoubleClickEvent dwcEv = new ListBoxDoubleClickEvent(this.listBox);
        Iterator<Consumer<ListBoxDoubleClickEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void doDoubleClick(Object key) {
        ListBoxDoubleClickEvent dwcEv = new ListBoxDoubleClickEvent(this.listBox);
        dwcEv.addKey(key);
        Iterator<Consumer<ListBoxDoubleClickEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<ListBoxDoubleClickEvent> callback) {
        this.targets.add(callback);
    }
}

