/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.listbox.sinks;

import com.basis.bbj.proxies.event.BBjListClickEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.listbox.ListBox;
import org.dwcj.controls.listbox.events.ListBoxSelectEvent;

public final class ListBoxSelectEventSink {
    private final ArrayList<Consumer<ListBoxSelectEvent>> targets = new ArrayList();
    private final ListBox listBox;

    public ListBoxSelectEventSink(ListBox listBox) {
        this.listBox = listBox;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(listBox);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(5, Environment.getInstance().getDwcjHelper().getEventProxy(this, "selectEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ListBoxSelectEventSink(ListBox listBox, Consumer<ListBoxSelectEvent> callback) {
        this.targets.add(callback);
        this.listBox = listBox;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(listBox);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(5, Environment.getInstance().getDwcjHelper().getEventProxy(this, "selectEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void selectEvent(BBjListClickEvent ev) {
        ListBoxSelectEvent dwcEv = new ListBoxSelectEvent(this.listBox);
        Iterator<Consumer<ListBoxSelectEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void doSelect(Object key) {
        ListBoxSelectEvent dwcEv = new ListBoxSelectEvent(this.listBox);
        dwcEv.addKey(key);
        Iterator<Consumer<ListBoxSelectEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<ListBoxSelectEvent> callback) {
        this.targets.add(callback);
    }
}

