/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.numericbox;

import com.basis.bbj.proxies.sysgui.BBjInputN;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import com.basis.util.common.BasisNumber;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.numericbox.events.NumericBoxEditModifyEvent;
import org.dwcj.controls.numericbox.sinks.NumericBoxEditModifyEventSink;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.HasReadOnly;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.interfaces.TextAlignable;
import org.dwcj.interfaces.TextHighlightable;
import org.dwcj.util.BBjFunctionalityHelper;

public class NumericBox
extends AbstractDwcControl
implements HasReadOnly,
Focusable,
TabTraversable,
TextAlignable,
TextHighlightable {
    protected BBjInputN numBox;
    protected ArrayList<Consumer<NumericBoxEditModifyEvent>> callbacks = new ArrayList();
    protected NumericBoxEditModifyEventSink editModifyEventSink;
    protected String commaChar = ",";
    protected String dotChar = ".";
    protected String editString = "";
    protected Boolean highlight = false;
    protected Boolean insertMode = true;
    protected Integer length = 9;
    protected Integer margin = 3;
    protected String mask = "-########";
    protected Boolean negatable = true;
    protected Boolean pEnter = false;
    protected Boolean pTab = false;
    protected float restore = 0.0f;
    protected Boolean commas = false;
    protected BigDecimal value = BigDecimal.valueOf(0L);

    public NumericBox(String text) {
        this.setText(text);
        this.readOnly = false;
        this.focusable = true;
        this.tabTraversable = true;
        this.textAlignment = TextAlignable.Alignment.LEFT;
        this.textHighlight = TextHighlightable.Highlight.HIGHLIGHT_NONE;
    }

    public NumericBox() {
        this("");
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addInputN(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, flags);
            this.numBox = (BBjInputN)this.ctrl;
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public NumericBox onEditModify(Consumer<NumericBoxEditModifyEvent> callback) {
        if (this.ctrl != null) {
            if (this.editModifyEventSink == null) {
                this.editModifyEventSink = new NumericBoxEditModifyEventSink(this);
            }
            this.editModifyEventSink.addCallback(callback);
        } else {
            this.callbacks.add(callback);
        }
        return this;
    }

    public String getCommaCharacter() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getCommaCharacter();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.commaChar;
    }

    public String getDotCharacter() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getDotCharacter();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.dotChar;
    }

    public String getEditString() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getEditString().toString();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.editString;
    }

    public Integer getError() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getError();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public Boolean isHighlight() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getHighlight();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.highlight;
    }

    public Boolean isInsertMode() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getInsertMode();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.insertMode;
    }

    public int getLength() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getLength();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.length;
    }

    public Integer getMargin() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getMargin();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.margin;
    }

    public String getMask() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getMask();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.mask;
    }

    public Boolean isNegatable() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getNegateable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.negatable;
    }

    public Boolean isPassEnter() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getPassEnter();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.pEnter;
    }

    public Boolean isPassTab() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getPassTab();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.pTab;
    }

    public String getRestore() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getRestore();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return String.valueOf(this.restore);
    }

    public Boolean isUseEditCommas() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getUseEditCommas();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.commas;
    }

    public BigDecimal getValue() {
        if (this.ctrl != null) {
            try {
                return this.numBox.getValue().toBigDecimal();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.value;
    }

    public void restore() {
        if (this.ctrl != null) {
            try {
                this.numBox.restore();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
    }

    public NumericBox selectAll() {
        if (this.ctrl != null) {
            try {
                this.numBox.selectAll();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public NumericBox setCommaCharacter(String comma) {
        if (this.ctrl != null) {
            try {
                this.numBox.setCommaCharacter(comma);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.commaChar = comma;
        return this;
    }

    public NumericBox setDotCharacter(String dot) {
        if (this.ctrl != null) {
            try {
                this.numBox.setDotCharacter(dot);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.dotChar = dot;
        return this;
    }

    public NumericBox setEditString(String edit) {
        if (this.ctrl != null) {
            try {
                this.numBox.setEditString(edit.getBytes());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.editString = edit;
        return this;
    }

    public NumericBox setHighlight(Boolean highlight) {
        if (this.ctrl != null) {
            try {
                this.numBox.setHighlight(highlight.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.highlight = highlight;
        return this;
    }

    public NumericBox setInsertMode(Boolean insert) {
        if (this.ctrl != null) {
            try {
                this.numBox.setInsertMode(insert.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.insertMode = insert;
        return this;
    }

    public NumericBox setLength(Integer len) {
        if (this.ctrl != null) {
            try {
                this.numBox.setLength(len.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.length = len;
        return this;
    }

    public NumericBox setMargin(Integer marginWidth) {
        if (this.ctrl != null) {
            try {
                this.numBox.setMargin(marginWidth.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.margin = marginWidth;
        return this;
    }

    public NumericBox setMask(String mask) {
        if (this.ctrl != null) {
            try {
                this.numBox.setMask(mask);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.mask = mask;
        return this;
    }

    public NumericBox setNegatable(boolean negatable) {
        if (this.ctrl != null) {
            try {
                this.numBox.setNegateable(negatable);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.negatable = negatable;
        return this;
    }

    public NumericBox setPassEnter(Boolean pass) {
        if (this.ctrl != null) {
            try {
                this.numBox.setPassEnter(pass.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.pEnter = pass;
        return this;
    }

    public NumericBox setPassTab(Boolean pass) {
        if (this.ctrl != null) {
            try {
                this.numBox.setPassEnter(pass.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.pTab = pass;
        return this;
    }

    public NumericBox setRestore(float restore) {
        if (this.ctrl != null) {
            try {
                this.numBox.setRestore(String.valueOf(restore));
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.restore = restore;
        return this;
    }

    public NumericBox setUseEditCommas(boolean useCommas) {
        if (this.ctrl != null) {
            try {
                this.numBox.setUseEditCommas(useCommas);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.commas = useCommas;
        return this;
    }

    public NumericBox setValue(BigDecimal value) {
        if (this.ctrl != null) {
            try {
                this.numBox.setValue((BBjNumber)BasisNumber.createBasisNumber((Object)value));
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.value = value;
        return this;
    }

    public NumericBox setValue(float value) {
        this.setValue(BigDecimal.valueOf(value));
        return this;
    }

    public NumericBox setValue(int value) {
        this.setValue(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        if (this.ctrl != null) {
            try {
                return !this.numBox.isEditable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.readOnly;
    }

    @Override
    public NumericBox setReadOnly(Boolean editable) {
        if (this.ctrl != null) {
            try {
                this.numBox.setEditable(editable == false);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                this.numBox.isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public NumericBox setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                this.numBox.setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                this.numBox.isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public NumericBox setTabTraversable(Boolean traverse) {
        if (this.ctrl != null) {
            try {
                this.numBox.setTabTraversable(traverse.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traverse;
        return this;
    }

    @Override
    public TextHighlightable.Highlight getHighlightOnFocus() {
        return this.textHighlight;
    }

    @Override
    public NumericBox setHighlightOnFocus(TextHighlightable.Highlight highlight) {
        if (this.ctrl != null) {
            try {
                this.numBox.setHighlightOnFocus(highlight.highlightType.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.textHighlight = highlight;
        return this;
    }

    @Override
    public TextAlignable.Alignment getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public NumericBox setTextAlignment(TextAlignable.Alignment alignment) {
        if (this.ctrl != null) {
            try {
                this.numBox.setAlignment(alignment.textPosition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.textAlignment = alignment;
        return this;
    }

    @Override
    public NumericBox setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public NumericBox setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public NumericBox setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public NumericBox setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public NumericBox setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public NumericBox setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public NumericBox setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public NumericBox addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public NumericBox removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public NumericBox setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    public NumericBox setTheme(Theme theme) {
        super.setControlTheme(theme);
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (!this.callbacks.isEmpty()) {
            this.editModifyEventSink = new NumericBoxEditModifyEventSink(this);
            while (!this.callbacks.isEmpty()) {
                this.editModifyEventSink.addCallback(this.callbacks.remove(0));
            }
        }
        if (!",".equals(this.commaChar)) {
            this.setCommaCharacter(this.commaChar);
        }
        if (!".".equals(this.dotChar)) {
            this.setDotCharacter(this.dotChar);
        }
        if (!"".equals(this.editString)) {
            this.setEditString(this.editString);
        }
        if (Boolean.TRUE.equals(this.highlight)) {
            this.setHighlight(this.highlight);
        }
        if (Boolean.FALSE.equals(this.insertMode)) {
            this.setInsertMode(this.insertMode);
        }
        if (this.length != 9) {
            this.setLength(this.length);
        }
        if (this.margin != 3) {
            this.setMargin(this.margin);
        }
        if (!"-########".equals(this.mask)) {
            this.setMask(this.mask);
        }
        if (Boolean.FALSE.equals(this.negatable)) {
            this.setNegatable(this.negatable);
        }
        if (Boolean.TRUE.equals(this.pEnter)) {
            this.setPassEnter(this.pEnter);
        }
        if (Boolean.TRUE.equals(this.pTab)) {
            this.setPassTab(this.pTab);
        }
        if (this.restore != 0.0f) {
            this.setRestore(this.restore);
        }
        if (Boolean.TRUE.equals(this.commas)) {
            this.setUseEditCommas(this.commas);
        }
        if (this.value.equals(BigDecimal.valueOf(0L))) {
            this.setValue(this.value);
        }
        if (Boolean.TRUE.equals(this.readOnly)) {
            this.setReadOnly(this.readOnly);
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
        if (this.textAlignment != TextAlignable.Alignment.LEFT) {
            this.setTextAlignment(this.textAlignment);
        }
        if (this.textHighlight != TextHighlightable.Highlight.HIGHLIGHT_NONE) {
            this.setHighlightOnFocus(this.textHighlight);
        }
    }

    public static enum Theme {
        DEFAULT,
        DANGER,
        GRAY,
        INFO,
        PRIMARY,
        SUCCESS,
        WARNING;

    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }
}

