/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.panels;

import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.dwcj.Environment;
import org.dwcj.annotations.AnnotationProcessor;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractControl;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.panels.PanelAccessorImpl;
import org.dwcj.exceptions.DwcAnnotationException;

public abstract class AbstractDwcjPanel
extends AbstractDwcControl {
    protected BBjWindow wnd;
    protected ArrayList<AbstractControl> controls = new ArrayList();
    private final HashSet<String> cssClasses = new HashSet();
    private final Map<String, String> styles = new HashMap<String, String>();

    public AbstractDwcjPanel add(AbstractControl ... ctrl) {
        for (AbstractControl c : ctrl) {
            if (!Boolean.FALSE.equals(c.isDestroyed())) continue;
            try {
                AnnotationProcessor processor = new AnnotationProcessor();
                processor.processControlAnnotations(c);
                ControlAccessor.getDefault().create(c, this);
                this.controls.add(c);
            }
            catch (IllegalAccessException | DwcAnnotationException e) {
                Environment.logError(e);
            }
        }
        return this;
    }

    BBjWindow getBBjWindow() {
        return this.wnd;
    }

    @Override
    public AbstractDwcjPanel setStyle(String property, String value) {
        this.styles.put(property, value);
        if (this.wnd != null) {
            this.wnd.setPanelStyle(property, value);
        }
        return this;
    }

    @Override
    public AbstractDwcjPanel addClassName(String selector) {
        this.cssClasses.add(selector);
        if (this.wnd != null) {
            try {
                this.wnd.addPanelStyle(selector);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    @Override
    public AbstractDwcjPanel removeClassName(String selector) {
        if (this.wnd != null) {
            try {
                this.wnd.removePanelStyle(selector);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        } else {
            this.cssClasses.remove(selector);
        }
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (!this.styles.isEmpty()) {
            for (Map.Entry entry : this.styles.entrySet()) {
                this.setStyle((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!this.cssClasses.isEmpty()) {
            for (String string : this.cssClasses) {
                this.addClassName(string);
            }
        }
    }

    static {
        PanelAccessor.setDefault(new PanelAccessorImpl());
    }
}

