/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.progressbar;

import com.basis.bbj.proxies.sysgui.BBjProgressBar;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.panels.AbstractDwcjPanel;

public final class ProgressBar
extends AbstractDwcControl {
    private BBjProgressBar bbjProgressBar;
    private Boolean indeterminate = false;
    private Integer maximum = 100;
    private Integer minimum = 0;
    private Integer orientation = 0;
    private Boolean stringPainted = true;
    private String text = "0%";
    private Integer value = 0;

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            this.ctrl = w.addProgressBar(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1);
            this.bbjProgressBar = (BBjProgressBar)this.ctrl;
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public Integer getMaximum() {
        if (this.ctrl != null) {
            try {
                return this.bbjProgressBar.getMaximum();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.maximum;
    }

    public Integer getMinimum() {
        if (this.ctrl != null) {
            try {
                return this.bbjProgressBar.getMinimum();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.minimum;
    }

    public Integer getOrientation() {
        if (this.ctrl != null) {
            try {
                return this.bbjProgressBar.getOrientation();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.orientation;
    }

    @Override
    public String getText() {
        if (this.ctrl != null) {
            try {
                return this.bbjProgressBar.getText();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.text;
    }

    public Integer getValue() {
        if (this.ctrl != null) {
            try {
                return this.bbjProgressBar.getValue();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.value;
    }

    public Boolean isIndeterminate() {
        if (this.ctrl != null) {
            try {
                return this.bbjProgressBar.isIndeterminate();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.indeterminate;
    }

    public Boolean isStringPainted() {
        if (this.ctrl != null) {
            try {
                return this.bbjProgressBar.isStringPainted();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.stringPainted;
    }

    public ProgressBar setIndeterminate(Boolean indeterminate) {
        if (this.ctrl != null) {
            try {
                this.bbjProgressBar.setIndeterminate(indeterminate.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ProgressBar setMaximum(Integer maximum) {
        if (this.ctrl != null) {
            try {
                this.bbjProgressBar.setMaximum(maximum.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.maximum = maximum;
        return this;
    }

    public ProgressBar setMinimum(Integer minimum) {
        if (this.ctrl != null) {
            try {
                this.bbjProgressBar.setMinimum(minimum.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.minimum = minimum;
        return this;
    }

    public ProgressBar setOrientation(Integer orientation) {
        if (this.ctrl != null) {
            try {
                this.bbjProgressBar.setOrientation(orientation.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.orientation = orientation;
        return this;
    }

    public ProgressBar setStringPainted(Boolean stringPainted) {
        if (this.ctrl != null) {
            try {
                this.bbjProgressBar.setStringPainted(stringPainted.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.stringPainted = stringPainted;
        return this;
    }

    public ProgressBar setProgressBarText(String text) {
        if (this.ctrl != null) {
            try {
                this.bbjProgressBar.setText(text);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.text = text;
        return this;
    }

    public ProgressBar setValue(Integer value) {
        if (this.ctrl != null) {
            try {
                this.bbjProgressBar.setValue(value.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.value = value;
        return this;
    }

    @Override
    public ProgressBar setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public ProgressBar setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public ProgressBar setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public ProgressBar setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public ProgressBar setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public ProgressBar setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public ProgressBar setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public ProgressBar addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public ProgressBar removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (Boolean.TRUE.equals(this.indeterminate)) {
            this.setIndeterminate(this.indeterminate);
        }
        if (this.maximum != 100) {
            this.setMaximum(this.maximum);
        }
        if (this.minimum != 0) {
            this.setMinimum(this.minimum);
        }
        if (this.orientation != 0) {
            this.setOrientation(this.orientation);
        }
        if (Boolean.FALSE.equals(this.stringPainted)) {
            this.setStringPainted(this.stringPainted);
        }
        if (!"0%".equals(this.text)) {
            this.setText(this.text);
        }
        if (this.value != 0) {
            this.setValue(this.value);
        }
    }

    public static enum Theme {
        DEFAULT,
        DANGER,
        GRAY,
        INFO,
        PRIMARY,
        SUCCESS,
        WARNING;

    }
}

