/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.radiobutton.sinks;

import com.basis.bbj.proxies.event.BBjCheckOffEvent;
import com.basis.bbj.proxies.event.BBjCheckOnEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.radiobutton.RadioButton;
import org.dwcj.controls.radiobutton.events.RadioButtonCheckEvent;

public final class RadioButtonCheckEventSink {
    private final ArrayList<Consumer<RadioButtonCheckEvent>> targets = new ArrayList();
    private final RadioButton radioButton;
    private BBjControl bbjControl;
    private static final String ON_EVENT = "onEvent";

    public RadioButtonCheckEventSink(RadioButton rb) {
        this.radioButton = rb;
        try {
            this.bbjControl = ControlAccessor.getDefault().getBBjControl(rb);
            Environment.getInstance().getBBjAPI();
            this.bbjControl.setCallback(26, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOffEvent"), ON_EVENT);
            Environment.getInstance().getBBjAPI();
            this.bbjControl.setCallback(25, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOnEvent"), ON_EVENT);
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public RadioButtonCheckEventSink(RadioButton rb, Consumer<RadioButtonCheckEvent> target) {
        this.targets.add(target);
        this.radioButton = rb;
        try {
            this.bbjControl = ControlAccessor.getDefault().getBBjControl(rb);
            Environment.getInstance().getBBjAPI();
            this.bbjControl.setCallback(26, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOffEvent"), ON_EVENT);
            Environment.getInstance().getBBjAPI();
            this.bbjControl.setCallback(25, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOnEvent"), ON_EVENT);
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void checkOffEvent(BBjCheckOffEvent ev) {
        RadioButtonCheckEvent dwcEv = new RadioButtonCheckEvent(this.radioButton, false);
        Iterator<Consumer<RadioButtonCheckEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void checkOnEvent(BBjCheckOnEvent ev) {
        RadioButtonCheckEvent dwcEv = new RadioButtonCheckEvent(this.radioButton, true);
        Iterator<Consumer<RadioButtonCheckEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<RadioButtonCheckEvent> callback) {
        this.targets.add(callback);
    }
}

