/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.scrollbar.sinks;

import com.basis.bbj.proxies.event.BBjControlScrollEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.scrollbar.ScrollBar;
import org.dwcj.controls.scrollbar.events.ScrollbarMoveEvent;

public class ScrollbarMoveEventSink {
    private ArrayList<Consumer<ScrollbarMoveEvent>> targets = new ArrayList();
    private final ScrollBar scrollBar;

    public ScrollbarMoveEventSink(ScrollBar sb) {
        this.scrollBar = sb;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(sb);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(3, Environment.getInstance().getDwcjHelper().getEventProxy(this, "scrollEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ScrollbarMoveEventSink(ScrollBar sb, Consumer<ScrollbarMoveEvent> callback) {
        this.targets.add(callback);
        this.scrollBar = sb;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(sb);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(3, Environment.getInstance().getDwcjHelper().getEventProxy(this, "scrollEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void scrollEvent(BBjControlScrollEvent ev) {
        ScrollbarMoveEvent dwcEv = new ScrollbarMoveEvent(this.scrollBar);
        Iterator<Consumer<ScrollbarMoveEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<ScrollbarMoveEvent> callback) {
        this.targets.add(callback);
    }
}

