/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.slider;

import com.basis.bbj.proxies.sysgui.BBjSlider;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.controls.slider.events.SliderOnControlScrollEvent;
import org.dwcj.controls.slider.sinks.SliderOnControlScrollEventSink;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.HasMouseWheelCondition;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.util.BBjFunctionalityHelper;

public final class Slider
extends AbstractDwcControl
implements Focusable,
HasMouseWheelCondition,
TabTraversable {
    private BBjSlider bbjSlider;
    private ArrayList<Consumer<SliderOnControlScrollEvent>> callbacks = new ArrayList();
    private SliderOnControlScrollEventSink scrollEventSink;
    private Orientation orientation = Orientation.HORIZONTAL;
    private Boolean inverted = false;
    private Integer majorTickSpacing = 1;
    private Integer minorTickSpacing = 1;
    private Integer maximum = 100;
    private Integer minimum = 0;
    private Boolean paintLabels = false;
    private Boolean paintTicks = false;
    private Boolean snapToTicks = false;
    private Integer value = 0;

    public Slider() {
        this.focusable = true;
        this.mouseWheelCondition = HasMouseWheelCondition.MouseWheelCondition.DEFAULT;
        this.tabTraversable = true;
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addHorizontalSlider(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_250, (BBjNumber)BASISNUMBER_250, flags);
            this.bbjSlider = (BBjSlider)this.ctrl;
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public Slider onScroll(Consumer<SliderOnControlScrollEvent> callback) {
        if (this.ctrl != null) {
            if (this.scrollEventSink == null) {
                this.scrollEventSink = new SliderOnControlScrollEventSink(this);
            }
            this.scrollEventSink.addCallback(callback);
        } else {
            this.callbacks.add(callback);
        }
        return this;
    }

    public Boolean isInverted() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getInverted();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.inverted;
    }

    public Map<Integer, String> getLabels() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getLabels();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return new HashMap<Integer, String>();
    }

    public Integer getMajorTickSpacing() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getMajorTickSpacing();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.majorTickSpacing;
    }

    public Integer getMaximum() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getMaximum();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.maximum;
    }

    public Integer getMinimum() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getMinimum();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.minimum;
    }

    public Integer getMinorTickSpacing() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getMinorTickSpacing();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.minorTickSpacing;
    }

    public Integer getOrientation() {
        if (this.ctrl != null) {
            return this.bbjSlider.getOrientation();
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            return 0;
        }
        return 1;
    }

    public Boolean isPaintLabels() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getPaintLabels();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.paintLabels;
    }

    public Boolean isPaintTicks() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getPaintTicks();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.paintTicks;
    }

    public Boolean isSnapToTicks() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getSnapToTicks();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.snapToTicks;
    }

    public Integer getValue() {
        if (this.ctrl != null) {
            try {
                return this.bbjSlider.getValue();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.value;
    }

    public Slider setInverted(Boolean inverted) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setInverted(inverted.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.inverted = inverted;
        return this;
    }

    public Slider setLabels(Map<Integer, String> labels) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setLabels(labels);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public Slider setMajorTickSpacing(Integer tick) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setMajorTickSpacing(tick.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.majorTickSpacing = tick;
        return this;
    }

    public Slider setMaximum(Integer maximum) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setMaximum(maximum.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.maximum = maximum;
        return this;
    }

    public Slider setMinimum(Integer minimum) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setMinimum(minimum.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.minimum = minimum;
        return this;
    }

    public Slider setMinorTickSpacing(Integer tick) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setMinorTickSpacing(tick.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.minorTickSpacing = tick;
        return this;
    }

    public Slider setOrientation(Orientation orientation) {
        if (this.ctrl != null) {
            this.setAttribute("orientation", orientation.value);
        }
        this.orientation = orientation;
        return this;
    }

    public Slider setPaintLabels(Boolean paint) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setPaintLabels(paint.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.paintLabels = paint;
        return this;
    }

    public Slider setPaintTicks(Boolean paint) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setPaintTicks(paint.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.paintTicks = paint;
        return this;
    }

    public Slider setSnapToTicks(Boolean snap) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setSnapToTicks(snap.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.snapToTicks = snap;
        return this;
    }

    public Slider setValue(Integer value) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setValue(value.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.value = value;
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public Slider setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public Slider setTabTraversable(Boolean traverse) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setTabTraversable(traverse.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traverse;
        return this;
    }

    @Override
    public HasMouseWheelCondition.MouseWheelCondition getScrollWheelBehavior() {
        return this.mouseWheelCondition;
    }

    @Override
    public Slider setScrollWheelBehavior(HasMouseWheelCondition.MouseWheelCondition condition) {
        if (this.ctrl != null) {
            try {
                this.bbjSlider.setScrollWheelBehavior(condition.mouseWheelEnabledCondition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    @Override
    public Slider setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public Slider setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public Slider setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public Slider setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public Slider setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public Slider setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public Slider setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public Slider addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public Slider removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public Slider setTheme(Theme theme) {
        super.setControlTheme(theme);
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (!this.callbacks.isEmpty()) {
            this.scrollEventSink = new SliderOnControlScrollEventSink(this);
            while (!this.callbacks.isEmpty()) {
                this.scrollEventSink.addCallback(this.callbacks.remove(0));
            }
        }
        if (Boolean.TRUE.equals(this.inverted)) {
            this.setInverted(this.inverted);
        }
        if (this.majorTickSpacing != 1) {
            this.setMajorTickSpacing(this.majorTickSpacing);
        }
        if (this.minorTickSpacing != 0) {
            this.setMinorTickSpacing(this.minorTickSpacing);
        }
        if (this.maximum != 100) {
            this.setMaximum(this.maximum);
        }
        if (this.minimum != 0) {
            this.setMinimum(this.minimum);
        }
        if (Boolean.TRUE.equals(this.paintLabels)) {
            this.setPaintLabels(this.paintLabels);
        }
        if (Boolean.TRUE.equals(this.paintTicks)) {
            this.setPaintTicks(this.paintLabels);
        }
        if (Boolean.TRUE.equals(this.snapToTicks)) {
            this.setPaintTicks(this.paintLabels);
        }
        if (this.value != 0) {
            this.setValue(this.value);
        }
        if (this.orientation != Orientation.HORIZONTAL) {
            this.setOrientation(Orientation.VERTICAL);
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
        if (this.mouseWheelCondition != HasMouseWheelCondition.MouseWheelCondition.DEFAULT) {
            this.setScrollWheelBehavior(this.mouseWheelCondition);
        }
    }

    public static enum Orientation {
        HORIZONTAL("horizontal"),
        VERTICAL("vertical");

        public final String value;

        private Orientation(String value) {
            this.value = value;
        }
    }

    public static enum Theme {
        DEFAULT,
        DANGER,
        GRAY,
        INFO,
        SUCCESS,
        WARNING;

    }
}

