/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.tabcontrol;

import com.basis.bbj.proxies.sysgui.BBjControl;
import com.basis.bbj.proxies.sysgui.BBjTabCtrl;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.controls.panels.Div;
import org.dwcj.controls.tabcontrol.events.TabSelectEvent;
import org.dwcj.controls.tabcontrol.sinks.TabSelectEventSink;

public final class TabControl
extends AbstractDwcControl {
    private TabSelectEventSink tabSelectEventSink;
    private ArrayList<Consumer<TabSelectEvent>> callbacks = new ArrayList();
    protected BBjTabCtrl tabCtrl;

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            this.tabCtrl = w.addTabCtrl(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1);
            this.ctrl = this.tabCtrl;
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    @Override
    public TabControl setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public TabControl setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public TabControl setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public TabControl setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public TabControl setAttribute(String attribute, String value) {
        try {
            this.ctrl.setAttribute(attribute, value);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
        return this;
    }

    @Override
    public TabControl setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public TabControl setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public TabControl addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public TabControl removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public TabControl setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    public TabControl setTheme(Theme theme) {
        super.setControlTheme(theme);
        return this;
    }

    public TabControl addTab(String text) {
        try {
            this.tabCtrl.addTab(text, -1);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
        return this;
    }

    public TabControl addTab(String text, Div panel) {
        try {
            this.tabCtrl.addTab(text, (BBjControl)PanelAccessor.getDefault().getBBjWindow(panel));
        }
        catch (BBjException | IllegalAccessException e) {
            Environment.logError((Exception)e);
        }
        return this;
    }

    public TabControl setPanelAt(int index, Div panel) {
        try {
            this.tabCtrl.setControlAt(index, (BBjControl)PanelAccessor.getDefault().getBBjWindow(panel));
        }
        catch (BBjException | IllegalAccessException e) {
            Environment.logError((Exception)e);
        }
        return this;
    }

    public TabControl onTabSelect(Consumer<TabSelectEvent> callback) {
        if (this.ctrl != null) {
            if (this.tabSelectEventSink == null) {
                this.tabSelectEventSink = new TabSelectEventSink(this);
            }
            this.tabSelectEventSink.addCallback(callback);
        } else {
            this.callbacks.add(callback);
        }
        return this;
    }

    public static enum Theme {
        DEFAULT,
        DANGER,
        GRAY,
        INFO,
        SUCCESS,
        WARNING;

    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }
}

