/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.tabcontrol.sinks;

import com.basis.bbj.proxies.event.BBjTabSelectedEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import com.basis.startup.type.BBjException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.tabcontrol.TabControl;
import org.dwcj.controls.tabcontrol.events.TabSelectEvent;

public final class TabSelectEventSink {
    private ArrayList<Consumer<TabSelectEvent>> targets = new ArrayList();
    private final TabControl tabControl;

    public TabSelectEventSink(TabControl btn) {
        this.tabControl = btn;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(btn);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(27, Environment.getInstance().getDwcjHelper().getEventProxy(this, "pushEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public TabSelectEventSink(TabControl tabControl, Consumer<TabSelectEvent> callback) {
        this.targets.add(callback);
        this.tabControl = tabControl;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(tabControl);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(2, Environment.getInstance().getDwcjHelper().getEventProxy(this, "pushEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void pushEvent(BBjTabSelectedEvent ev) {
        TabSelectEvent dwcEv = null;
        try {
            dwcEv = new TabSelectEvent(this.tabControl, ev.getIndex(), ev.getTitle());
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
        Iterator<Consumer<TabSelectEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<TabSelectEvent> callback) {
        this.targets.add(callback);
    }
}

