/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.textarea;

import com.basis.bbj.proxies.sysgui.BBjCEdit;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.controls.textarea.events.TextAreaOnEditModifyEvent;
import org.dwcj.controls.textarea.sinks.TextAreaOnEditModifyEventSink;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.HasMouseWheelCondition;
import org.dwcj.interfaces.HasReadOnly;
import org.dwcj.interfaces.Scrollable;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.interfaces.TextHighlightable;
import org.dwcj.util.BBjFunctionalityHelper;

public final class TextArea
extends AbstractDwcControl
implements HasReadOnly,
TextHighlightable,
Focusable,
HasMouseWheelCondition,
Scrollable,
TabTraversable {
    private BBjCEdit bbjCEdit;
    private ArrayList<Consumer<TextAreaOnEditModifyEvent>> callbacks = new ArrayList();
    private TextAreaOnEditModifyEventSink editModifyEventSink;
    private Boolean hScroll = false;
    private Boolean ignoreEnter = false;
    private Boolean ignoreTab = false;
    private Boolean oneParagraph = false;
    private Integer lineLimit = null;
    private Boolean lineWrap = false;
    private Integer maxParagraphSize = null;
    private Integer maxLength = Integer.MAX_VALUE;
    private Boolean overtype = false;
    private Integer tabSize = 8;
    private Boolean vScroll = false;
    private Boolean wrapWord = true;

    public TextArea() {
        this.readOnly = false;
        this.textHighlight = TextHighlightable.Highlight.HIGHLIGHT_NONE;
        this.horizontalScrollBarPosition = 0;
        this.verticalScrollBarPosition = 0;
        this.focusable = true;
        this.mouseWheelCondition = HasMouseWheelCondition.MouseWheelCondition.DEFAULT;
        this.tabTraversable = true;
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addCEdit(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, super.getText(), flags);
            this.bbjCEdit = (BBjCEdit)this.ctrl;
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public TextArea onEditModify(Consumer<TextAreaOnEditModifyEvent> callback) {
        if (this.ctrl != null) {
            if (this.editModifyEventSink == null) {
                this.editModifyEventSink = new TextAreaOnEditModifyEventSink(this);
            }
            this.editModifyEventSink.addCallback(callback);
        } else {
            this.callbacks.add(callback);
        }
        return this;
    }

    public TextArea addParagraph(Integer index, String paragraph) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.addParagraph(index.intValue(), paragraph);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public TextArea appendToParagraph(Integer parNum, String text) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.appendToParagraph(parNum.intValue(), text);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public List<String> getAllParagraphs() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getAllParagraphs();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return new ArrayList<String>();
    }

    public Integer getCurrentParagraphIndex() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getCurrentParagraphIndex();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return -1;
    }

    public Boolean isHorizontalScrollable() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getHorizontalScrollable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public Boolean isIgnoreEnters() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getIgnoreEnters();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public Boolean isIgnoreTabs() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getIgnoreTabs();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public Boolean isLimitToOneParagraph() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getLimitToOneParagraph();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public Integer getLineCountLimit() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getLineCountLimit();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return -1;
    }

    public Boolean isLineWrap() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getLineWrap();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public Integer getMaxParagraphSize() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getMaxParagraphSize();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return -1;
    }

    public Integer getMaxLength() {
        if (this.ctrl != null) {
            return this.bbjCEdit.getMaxLength();
        }
        return Integer.MAX_VALUE;
    }

    public Integer getNumberOfParagraphs() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getNumberOfParagraphs();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return 0;
    }

    public Boolean isOvertypeMode() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getOvertypeMode();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public String getParagraph(Integer parNum) {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getParagraph(parNum.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return "";
    }

    public List<String> getSelection() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getSelection();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return Collections.emptyList();
    }

    public Integer getTabSize() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getTabSize();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return 8;
    }

    public Boolean isVerticalScrollable() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getVerticalScrollable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public Boolean isWrapStyleWord() {
        if (this.ctrl != null) {
            try {
                return this.bbjCEdit.getWrapStyleWord();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public void highlight(Integer parIndex1, Integer off1, Integer parIndex2, Integer off2) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.highlight(parIndex1.intValue(), off1.intValue(), parIndex2.intValue(), off2.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
    }

    public void removeAll() {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.removeAll();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
    }

    public TextArea removeParagraph(Integer parIndex) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.removeParagraph(parIndex.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public TextArea setHorizontalScrollable(Boolean scroll) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setHorizontalScrollable(scroll.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.hScroll = scroll;
        return this;
    }

    public TextArea setIgnoreEnters(Boolean ignore) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setIgnoreEnters(ignore.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.ignoreEnter = ignore;
        return this;
    }

    public TextArea setIgnoreTabs(Boolean ignore) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setIgnoreTabs(ignore.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.ignoreTab = ignore;
        return this;
    }

    public TextArea setLimitToOneParagraph(Boolean limit) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setLimitToOneParagraph(limit.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.oneParagraph = limit;
        return this;
    }

    public TextArea setLineCountLimit(Integer limit) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setLineCountLimit(limit.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.lineLimit = limit;
        return this;
    }

    public TextArea setLineWrap(Boolean wrap) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setLineWrap(wrap.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.lineWrap = wrap;
        return this;
    }

    public TextArea setMaxParagraphSize(Integer size) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setMaxParagraphSize(size.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.maxParagraphSize = size;
        return this;
    }

    public TextArea setMaxLength(Integer length) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setMaxLength(length.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.maxLength = length;
        return this;
    }

    public TextArea setOvertypeMode(Boolean overtype) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setOvertypeMode(overtype.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.overtype = overtype;
        return this;
    }

    public TextArea setTabSize(Integer size) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setTabSize(size.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabSize = size;
        return this;
    }

    public TextArea setVerticalScrollable(Boolean scroll) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setVerticalScrollable(scroll.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.vScroll = scroll;
        return this;
    }

    public TextArea setWrapStyleWord(Boolean word) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setWrapStyleWord(word.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.wrapWord = word;
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        if (this.ctrl != null) {
            try {
                return !this.bbjCEdit.isEditable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.readOnly;
    }

    @Override
    public TextArea setReadOnly(Boolean editable) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setEditable(editable == false);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.readOnly = editable;
        return this;
    }

    @Override
    public TextHighlightable.Highlight getHighlightOnFocus() {
        return this.textHighlight;
    }

    @Override
    public TextArea setHighlightOnFocus(TextHighlightable.Highlight highlight) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setHighlightOnFocus(highlight.highlightType.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.textHighlight = highlight;
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public TextArea setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public HasMouseWheelCondition.MouseWheelCondition getScrollWheelBehavior() {
        return this.mouseWheelCondition;
    }

    @Override
    public TextArea setScrollWheelBehavior(HasMouseWheelCondition.MouseWheelCondition condition) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setScrollWheelBehavior(condition.mouseWheelEnabledCondition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.mouseWheelCondition = condition;
        return this;
    }

    @Override
    public Integer getHorizontalScrollBarHeight() {
        if (this.ctrl != null) {
            this.bbjCEdit.getHorizontalScrollBarHeight();
        }
        return 0;
    }

    @Override
    public Integer getHorizontalScrollBarPosition() {
        if (this.ctrl != null) {
            this.bbjCEdit.getHorizontalScrollBarPosition();
        }
        return this.verticalScrollBarPosition;
    }

    @Override
    public Integer getHorizontalScrollBarWidth() {
        if (this.ctrl != null) {
            this.bbjCEdit.getHorizontalScrollBarWidth();
        }
        return 0;
    }

    @Override
    public Integer getVerticalScrollBarHeight() {
        if (this.ctrl != null) {
            this.bbjCEdit.getVerticalScrollBarHeight();
        }
        return 0;
    }

    @Override
    public Integer getVerticalScrollBarPosition() {
        if (this.ctrl != null) {
            this.bbjCEdit.getVerticalScrollBarPosition();
        }
        return this.horizontalScrollBarPosition;
    }

    @Override
    public Integer getVerticalScrollBarWidth() {
        if (this.ctrl != null) {
            this.bbjCEdit.getVerticalScrollBarWidth();
        }
        return 0;
    }

    @Override
    public Boolean isHorizontalScrollBarVisible() {
        if (this.ctrl != null) {
            this.bbjCEdit.isHorizontalScrollBarVisible();
        }
        return false;
    }

    @Override
    public Boolean isVerticalScrollBarVisible() {
        if (this.ctrl != null) {
            this.bbjCEdit.isVerticalScrollBarVisible();
        }
        return false;
    }

    @Override
    public TextArea setHorizontalScrollBarPosition(Integer position) {
        if (this.ctrl != null) {
            this.bbjCEdit.setHorizontalScrollBarPosition(position.intValue());
        }
        this.horizontalScrollBarPosition = position;
        return this;
    }

    @Override
    public TextArea setVerticalScrollBarPosition(Integer position) {
        if (this.ctrl != null) {
            this.bbjCEdit.setVerticalScrollBarPosition(position.intValue());
        }
        this.verticalScrollBarPosition = position;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public TextArea setTabTraversable(Boolean traversable) {
        if (this.ctrl != null) {
            try {
                this.bbjCEdit.setTabTraversable(traversable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traversable;
        return this;
    }

    @Override
    public TextArea setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public TextArea setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public TextArea setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public TextArea setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public TextArea setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public TextArea setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public TextArea setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public TextArea addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public TextArea removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public TextArea setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    public TextArea setTheme(Theme theme) {
        super.setControlTheme(theme);
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (!this.callbacks.isEmpty()) {
            this.editModifyEventSink = new TextAreaOnEditModifyEventSink(this);
            while (!this.callbacks.isEmpty()) {
                this.editModifyEventSink.addCallback(this.callbacks.remove(0));
            }
        }
        if (Boolean.TRUE.equals(this.hScroll)) {
            this.setHorizontalScrollable(this.hScroll);
        }
        if (Boolean.TRUE.equals(this.ignoreEnter)) {
            this.setIgnoreEnters(this.ignoreEnter);
        }
        if (Boolean.TRUE.equals(this.ignoreTab)) {
            this.setIgnoreTabs(this.ignoreTab);
        }
        if (Boolean.TRUE.equals(this.oneParagraph)) {
            this.setLimitToOneParagraph(this.oneParagraph);
        }
        if (this.lineLimit != null) {
            this.setLineCountLimit(this.lineLimit);
        }
        if (Boolean.TRUE.equals(this.lineWrap)) {
            this.setLineWrap(this.lineWrap);
        }
        if (this.maxParagraphSize != null) {
            this.setMaxParagraphSize(this.maxParagraphSize);
        }
        if (this.maxLength != Integer.MAX_VALUE) {
            this.setMaxLength(this.maxLength);
        }
        if (Boolean.TRUE.equals(this.overtype)) {
            this.setOvertypeMode(this.overtype);
        }
        if (this.tabSize != 8) {
            this.setTabSize(this.tabSize);
        }
        if (Boolean.TRUE.equals(this.vScroll)) {
            this.setVerticalScrollable(this.vScroll);
        }
        if (Boolean.FALSE.equals(this.wrapWord)) {
            this.setWrapStyleWord(this.wrapWord);
        }
        if (Boolean.TRUE.equals(this.readOnly)) {
            this.setReadOnly(this.readOnly);
        }
        if (this.textHighlight != TextHighlightable.Highlight.HIGHLIGHT_NONE) {
            this.setHighlightOnFocus(this.textHighlight);
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (this.horizontalScrollBarPosition != 0) {
            this.setHorizontalScrollBarPosition(this.horizontalScrollBarPosition);
        }
        if (this.verticalScrollBarPosition != 0) {
            this.setVerticalScrollBarPosition(this.horizontalScrollBarPosition);
        }
        if (this.mouseWheelCondition != HasMouseWheelCondition.MouseWheelCondition.DEFAULT) {
            this.setScrollWheelBehavior(this.mouseWheelCondition);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
    }

    public static enum Theme {
        DEFAULT,
        DANGER,
        GRAY,
        INFO,
        PRIMARY,
        SUCCESS,
        WARNING;

    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }
}

