/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.treeview;

import com.basis.bbj.proxies.sysgui.BBjImage;
import com.basis.bbj.proxies.sysgui.BBjTree;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import com.basis.startup.type.BBjVector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.controls.treeview.events.TreeCollapseEvent;
import org.dwcj.controls.treeview.events.TreeDeselectEvent;
import org.dwcj.controls.treeview.events.TreeDoubleClickedEvent;
import org.dwcj.controls.treeview.events.TreeEditStoppedEvent;
import org.dwcj.controls.treeview.events.TreeExpandedEvent;
import org.dwcj.controls.treeview.events.TreeGainedFocusEvent;
import org.dwcj.controls.treeview.events.TreeLostFocusEvent;
import org.dwcj.controls.treeview.events.TreeSelectedEvent;
import org.dwcj.controls.treeview.sinks.TreeCollapseEventSink;
import org.dwcj.controls.treeview.sinks.TreeDeselectEventSink;
import org.dwcj.controls.treeview.sinks.TreeDoubleClickEventSink;
import org.dwcj.controls.treeview.sinks.TreeEditStopEventSink;
import org.dwcj.controls.treeview.sinks.TreeExpandEventSink;
import org.dwcj.controls.treeview.sinks.TreeGainedFocusEventSink;
import org.dwcj.controls.treeview.sinks.TreeLostFocusEventSink;
import org.dwcj.controls.treeview.sinks.TreeSelectEventSink;
import org.dwcj.models.Icon;

public final class TreeView
extends AbstractDwcControl {
    private BBjTree tree;

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            this.ctrl = w.addTree(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1);
            this.tree = (BBjTree)this.ctrl;
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void addExpandableNode(int childID, int parentID, String text) {
        try {
            this.tree.addExpandableNode(childID, parentID, text);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void addNode(int childID, int parentID, String text) {
        try {
            this.tree.addNode(childID, parentID, text);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void clearImageSize() {
        try {
            this.tree.clearImageSize();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public int getChild(int parentID, int index) {
        try {
            return this.tree.getChildAt(parentID, index);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return 0;
        }
    }

    public int getChildIndex(int parentID) {
        try {
            return this.tree.getIndexOfChild(parentID);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return 0;
        }
    }

    public int getParentNode(int childID) {
        try {
            return this.tree.getParentNode(childID);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return 0;
        }
    }

    public int getRoot() {
        try {
            return this.tree.getRoot();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return 0;
        }
    }

    public void insertExpandableNode(int childID, int parentID, String text, int index) {
        try {
            this.tree.insertExpandableNode(childID, parentID, text, index);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void insertNode(int childID, int parentID, String text, int index) {
        try {
            this.tree.insertNode(childID, parentID, text, index);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public boolean isLeafNode(int id) {
        try {
            return this.tree.isNodeLeaf(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return false;
        }
    }

    public void removeDescendants(int id) {
        try {
            this.tree.removeDescendants(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void removeNode(int id) {
        try {
            this.tree.removeNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setRoot(int id, String text) {
        try {
            this.tree.setRoot(id, text);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void collapseNode(int id) {
        try {
            this.tree.collapseNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void collapseTreeFromNode(int id) {
        try {
            this.tree.collapseTreeFromNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void expandNode(int id) {
        try {
            this.tree.expandNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void expandTreeFromNode(int id) {
        try {
            this.tree.expandTreeFromNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public int getCollapsedNode() {
        try {
            return this.tree.getCollapsedNode();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return 0;
        }
    }

    public int getExpandedNode() {
        try {
            return this.tree.getExpandedNode();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return 0;
        }
    }

    public List<Integer> getExpandedNodes() {
        try {
            return this.tree.getExpandedNodes();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return new ArrayList<Integer>();
        }
    }

    public boolean isNodeExpandable(int id) {
        try {
            return this.tree.isNodeExpandable(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean isNodeExpanded(int id) {
        try {
            return this.tree.isNodeExpanded(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return false;
        }
    }

    public String getNodeText(int id) {
        try {
            return this.tree.getNodeText(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return "";
        }
    }

    public void setNodeText(int id, String text) {
        try {
            this.tree.setNodeText(id, text);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void editNode(int id) {
        try {
            this.tree.editNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void endEdit() {
        try {
            this.tree.endEdit();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public boolean isNodeEditable(int id) {
        try {
            return this.tree.isNodeEditable(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean isTreeEditable() {
        try {
            return this.tree.isTreeEditable();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return false;
        }
    }

    public void setNodeEditable(int id, boolean editable) {
        try {
            this.tree.setNodeEditable(id, editable);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setTreeEditable(boolean editable) {
        try {
            this.tree.setTreeEditable(editable);
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void clearNodeIcon(int id) {
        try {
            this.tree.clearNodeIcon(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void clearNodeSelectedIcon(int id) {
        try {
            this.tree.clearNodeSelectedIcon(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setCollapsedIcon(Icon icon) {
        try {
            this.tree.setCollapsedIcon((BBjImage)icon.getFile());
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setExpandedIcon(Icon icon) {
        try {
            this.tree.setExpandedIcon((BBjImage)icon.getFile());
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setLeafIcon(Icon icon) {
        try {
            this.tree.setLeafIcon((BBjImage)icon.getFile());
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setNodeIcon(int id, Icon icon) {
        try {
            this.tree.setNodeIcon(id, (BBjImage)icon.getFile());
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setNodeSelectedIcon(int id, Icon icon) {
        try {
            this.tree.setNodeSelectedIcon(id, (BBjImage)icon.getFile());
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setSelectedIcon(Icon icon) {
        try {
            this.tree.setSelectedIcon((BBjImage)icon.getFile());
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void deselectAll() {
        try {
            this.tree.deselectAll();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void deselectChildren(int parentID) {
        try {
            this.tree.deselectChildren(parentID);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void deselectNode(int id) {
        try {
            this.tree.deselectNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public int getSelectedNode() {
        try {
            return this.tree.getSelectedNode();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return 0;
        }
    }

    public List<Integer> getSelectedNodes() {
        try {
            return this.tree.getSelectedNodes();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return new ArrayList<Integer>();
        }
    }

    public int getSelectionMode() {
        return this.tree.getSelectionMode();
    }

    public boolean isNodeSelected(int id) {
        try {
            this.tree.isNodeSelected(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void selectChildren(int parentID) {
        try {
            this.tree.selectChildren(parentID);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void selectNode(int id) {
        try {
            this.tree.selectNode(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setNodeVisible(int id) {
        try {
            this.tree.setNodeVisible(id);
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
    }

    public void setSelectionMode(int mode) {
        this.tree.setSelectionMode(mode);
    }

    public String getNodeToolTipText(int id) {
        try {
            return this.tree.getToolTipText(id);
        }
        catch (Exception e) {
            Environment.logError(e);
            return "";
        }
    }

    public void setNodeToolTipText(int id, String text) {
        try {
            this.tree.setToolTipText(id, text);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public boolean isDragEnabled() {
        return this.tree.getDragEnabled();
    }

    public String getDragType(int id) {
        try {
            return this.tree.getDragType(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return "";
        }
    }

    public List<String> getDropTypes(int id) {
        try {
            return this.tree.getDropTypes(id);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
            return new ArrayList<String>();
        }
    }

    public void setDragEnabled(boolean enabled) {
        this.tree.setDragEnabled(enabled);
    }

    public void setDragType(int id, String type) {
        try {
            this.tree.setDragType(id, type);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public void setDropTypes(int id, List<String> types) {
        try {
            this.tree.setDropTypes(id, (BBjVector)types);
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public TreeView onGainedFocus(Consumer<TreeGainedFocusEvent> callback) {
        new TreeGainedFocusEventSink(this, callback);
        return this;
    }

    public TreeView onLostFocus(Consumer<TreeLostFocusEvent> callback) {
        new TreeLostFocusEventSink(this, callback);
        return this;
    }

    public TreeView onSelect(Consumer<TreeSelectedEvent> callback) {
        new TreeSelectEventSink(this, callback);
        return this;
    }

    public TreeView onDeselect(Consumer<TreeDeselectEvent> callback) {
        new TreeDeselectEventSink(this, callback);
        return this;
    }

    public TreeView onExpand(Consumer<TreeExpandedEvent> callback) {
        new TreeExpandEventSink(this, callback);
        return this;
    }

    public TreeView onCollapse(Consumer<TreeCollapseEvent> callback) {
        new TreeCollapseEventSink(this, callback);
        return this;
    }

    public TreeView onEditStopped(Consumer<TreeEditStoppedEvent> callback) {
        new TreeEditStopEventSink(this, callback);
        return this;
    }

    public TreeView onDoubleClick(Consumer<TreeDoubleClickedEvent> callback) {
        new TreeDoubleClickEventSink(this, callback);
        return this;
    }

    @Override
    public TreeView setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public TreeView setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public TreeView setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public TreeView setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public TreeView setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public TreeView setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public TreeView setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public TreeView addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public TreeView removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public TreeView setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }
}

