/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.environment.namespace;

import com.basis.bbj.proxies.BBjNamespace;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjVector;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.dwcj.environment.namespace.CanLock;
import org.dwcj.environment.namespace.Namespace;
import org.dwcj.environment.namespace.NamespaceVarableLockedException;
import org.dwcj.environment.namespace.events.NamespaceEvent;
import org.dwcj.environment.namespace.sinks.NamespaceEventSink;

public abstract class StandardNamespace
implements Namespace,
CanLock {
    protected BBjNamespace ns;

    @Override
    public void put(String key, Object value) throws NamespaceVarableLockedException {
        try {
            this.ns.setValue(key, value);
        }
        catch (BBjException e) {
            throw new NamespaceVarableLockedException();
        }
    }

    @Override
    public Object get(String key) {
        try {
            return this.ns.getValue(key);
        }
        catch (BBjException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove(String key) throws NamespaceVarableLockedException {
        try {
            this.ns.removeValue(key);
        }
        catch (BBjException e) {
            throw new NamespaceVarableLockedException();
        }
    }

    @Override
    public Set<String> keySet() {
        BBjVector tmp;
        HashSet<String> keyset = new HashSet<String>();
        try {
            tmp = this.ns.getKeys();
        }
        catch (BBjException e) {
            return keyset;
        }
        for (Object o : tmp) {
            keyset.add(o.toString());
        }
        return keyset;
    }

    @Override
    public int size() {
        try {
            return this.ns.getKeys().size();
        }
        catch (BBjException e) {
            return -1;
        }
    }

    @Override
    public void clear() {
        this.ns.clear();
    }

    @Override
    public void setLock(String key, long timeout) throws NamespaceVarableLockedException {
        try {
            this.ns.setLock(key, timeout);
        }
        catch (BBjException e) {
            throw new NamespaceVarableLockedException();
        }
    }

    @Override
    public void removeLock(String key) {
        try {
            this.ns.removeLock(key);
        }
        catch (BBjException bBjException) {
            // empty catch block
        }
    }

    public StandardNamespace onChange(Consumer<NamespaceEvent> consumer) {
        new NamespaceEventSink(this.ns, true, consumer);
        return this;
    }

    public StandardNamespace onAccess(Consumer<NamespaceEvent> consumer) {
        new NamespaceEventSink(this.ns, false, consumer);
        return this;
    }

    public StandardNamespace onVariableChange(String key, Consumer<NamespaceEvent> consumer) {
        new NamespaceEventSink(this.ns, key, true, consumer);
        return this;
    }

    public StandardNamespace onVariableAccess(String key, Consumer<NamespaceEvent> consumer) {
        new NamespaceEventSink(this.ns, key, false, consumer);
        return this;
    }
}

