/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.environment.namespace.sinks;

import com.basis.bbj.proxies.BBjNamespace;
import com.basis.bbj.proxies.event.BBjNamespaceEvent;
import com.basis.startup.type.BBjException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import org.dwcj.App;
import org.dwcj.Environment;
import org.dwcj.environment.namespace.events.NamespaceEvent;

public final class NamespaceEventSink {
    private static final HashMap<String, ArrayList<Consumer<NamespaceEvent>>> variableAccessTargets = new HashMap();
    private static final HashMap<String, ArrayList<Consumer<NamespaceEvent>>> variableChangeTargets = new HashMap();
    private static final HashMap<String, ArrayList<Consumer<NamespaceEvent>>> namespaceAccessTargets = new HashMap();
    private static final HashMap<String, ArrayList<Consumer<NamespaceEvent>>> namespaceChangeTargets = new HashMap();
    public static final String ON_EVENT = "onEvent";

    public NamespaceEventSink(BBjNamespace ns, Boolean fChangeOnly, Consumer<NamespaceEvent> consumer) {
        this(ns, null, fChangeOnly, consumer);
    }

    public NamespaceEventSink(BBjNamespace ns, String key, Boolean fChangeOnly, Consumer<NamespaceEvent> consumer) {
        String nsname = "";
        if (ns != null) {
            String nskey = null;
            if (key != null) {
                nskey = key;
            }
            if (nskey == null) {
                if (Boolean.TRUE.equals(fChangeOnly)) {
                    try {
                        ns.setCallbackForNamespaceChange(Environment.getInstance().getDwcjHelper().getEventProxy(this, "onNsChange"), ON_EVENT);
                        ArrayList consumerlist = namespaceChangeTargets.computeIfAbsent(nsname, k -> new ArrayList());
                        consumerlist.add(consumer);
                    }
                    catch (BBjException e) {
                        App.consoleLog(e.getMessage());
                    }
                } else {
                    try {
                        ns.setCallbackForNamespace(Environment.getInstance().getDwcjHelper().getEventProxy(this, "onNsAccess"), ON_EVENT);
                        ArrayList consumerlist = namespaceAccessTargets.computeIfAbsent(nsname, k -> new ArrayList());
                        consumerlist.add(consumer);
                    }
                    catch (BBjException e) {
                        App.consoleLog(e.getMessage());
                    }
                }
            } else if (Boolean.TRUE.equals(fChangeOnly)) {
                try {
                    ns.setCallbackForVariableChange(key, Environment.getInstance().getDwcjHelper().getEventProxy(this, "onVarChange"), ON_EVENT);
                    ArrayList consumerlist = variableChangeTargets.computeIfAbsent(nsname + "\u0000" + key, k -> new ArrayList());
                    consumerlist.add(consumer);
                }
                catch (BBjException e) {
                    App.consoleLog(e.getMessage());
                }
            } else {
                try {
                    ns.setCallbackForVariable(key, Environment.getInstance().getDwcjHelper().getEventProxy(this, "onVarAccess"), ON_EVENT);
                    ArrayList consumerlist = variableAccessTargets.computeIfAbsent(nsname + "\u0000" + key, k -> new ArrayList());
                    consumerlist.add(consumer);
                }
                catch (BBjException e) {
                    App.consoleLog(e.getMessage());
                }
            }
        }
    }

    public void onNsChange(BBjNamespaceEvent ev) {
        ArrayList<Consumer<NamespaceEvent>> consumerlist;
        NamespaceEvent nsEvent = new NamespaceEvent(ev.getNamespaceName(), ev.getVariableName(), ev.getOldValue(), ev.getNewValue());
        if (namespaceChangeTargets != null && (consumerlist = namespaceChangeTargets.get(ev.getNamespaceName())) != null) {
            for (Consumer<NamespaceEvent> consumer : consumerlist) {
                consumer.accept(nsEvent);
            }
        }
    }

    public void onNsAccess(BBjNamespaceEvent ev) {
        ArrayList<Consumer<NamespaceEvent>> consumerlist;
        NamespaceEvent nsEvent = new NamespaceEvent(ev.getNamespaceName(), ev.getVariableName(), ev.getOldValue(), ev.getNewValue());
        if (namespaceAccessTargets != null && (consumerlist = namespaceAccessTargets.get(ev.getNamespaceName())) != null) {
            for (Consumer<NamespaceEvent> consumer : consumerlist) {
                consumer.accept(nsEvent);
            }
        }
    }

    public void onVarChange(BBjNamespaceEvent ev) {
        ArrayList<Consumer<NamespaceEvent>> consumerlist;
        NamespaceEvent nsEvent = new NamespaceEvent(ev.getNamespaceName(), ev.getVariableName(), ev.getOldValue(), ev.getNewValue());
        if (variableChangeTargets != null && (consumerlist = variableChangeTargets.get(ev.getNamespaceName() + "\u0000" + ev.getVariableName())) != null) {
            for (Consumer<NamespaceEvent> consumer : consumerlist) {
                consumer.accept(nsEvent);
            }
        }
    }

    public void onVarAccess(BBjNamespaceEvent ev) {
        ArrayList<Consumer<NamespaceEvent>> consumerlist;
        NamespaceEvent nsEvent = new NamespaceEvent(ev.getNamespaceName(), ev.getVariableName(), ev.getOldValue(), ev.getNewValue());
        if (variableAccessTargets != null && (consumerlist = variableAccessTargets.get(ev.getNamespaceName() + "\u0000" + ev.getVariableName())) != null) {
            for (Consumer<NamespaceEvent> consumer : consumerlist) {
                consumer.accept(nsEvent);
            }
        }
    }
}

