/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.models;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.dwcj.Environment;

public class Icon {
    private File file;

    public Icon loadFromFile(File file) {
        this.file = file;
        return this;
    }

    public Icon loadFromURL(String url) {
        try {
            this.file = new File(new URL(url).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            Environment.logError(e);
        }
        return this;
    }

    public Icon loadFromResources(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resource);
        try {
            FileOutputStream outputStream = new FileOutputStream(this.file);
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            Environment.logError(e);
        }
        return this;
    }

    public File getFile() {
        return this.file;
    }
}

