/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AppFinder {
    private final Class appBaseClass;
    private final TreeSet<String> appImplmentations = new TreeSet();
    private final List<String> cpEntriesToCheck;

    public AppFinder(List<String> cpEntriesToCheck) throws ClassNotFoundException {
        this.cpEntriesToCheck = cpEntriesToCheck;
        this.appBaseClass = Class.forName("org.dwcj.App");
    }

    private void checkClass(String className) {
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName(className, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return;
        }
        if (tmpClass != null && this.appBaseClass.isAssignableFrom(tmpClass) && !className.equals("org.dwcj.App") && !className.equals("org.dwcj.util.WelcomeApp")) {
            this.appImplmentations.add(className);
        }
    }

    public Set<String> getAppImplmentations() {
        if (this.cpEntriesToCheck != null) {
            for (String s : this.cpEntriesToCheck) {
                this.process(s);
            }
        }
        return this.appImplmentations;
    }

    private void process(String filepath) {
        this.processFile(filepath, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFile(String base, String curFile) {
        String nextfile = base + File.separatorChar + curFile;
        File currentDirectory = new File(nextfile);
        if (currentDirectory.getName().endsWith(".jar")) {
            try {
                if (!currentDirectory.exists()) return;
                this.processJar(new ZipFile(currentDirectory));
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            HashSet<File> myDirectories = new HashSet<File>();
            File[] myFiles = currentDirectory.listFiles();
            if (myFiles == null || myFiles.length == 0) {
                return;
            }
            for (File myFile : myFiles) {
                if (myFile.isDirectory()) {
                    myDirectories.add(myFile);
                    continue;
                }
                if (!myFile.getName().endsWith(".class")) continue;
                String className = this.getClassName(curFile + (curFile.isBlank() ? "" : File.separator) + myFile.getName());
                this.checkClass(className);
            }
            for (Object e : myDirectories) {
                this.processFile(base, curFile + (curFile.isBlank() ? "" : File.separator) + ((File)e).getName());
            }
        }
    }

    private String getClassName(String fileName) {
        String className = fileName.replace(File.separatorChar, '.');
        className = className.replace('/', '.');
        return className.substring(0, fileName.length() - 6);
    }

    private void processJar(ZipFile file) {
        Enumeration<? extends ZipEntry> files = file.entries();
        while (files.hasMoreElements()) {
            ZipEntry tfile = files.nextElement();
            ZipEntry child = tfile;
            if (!child.getName().endsWith(".class")) continue;
            this.checkClass(this.getClassName(child.getName()));
        }
    }
}

