/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.addons.markdown;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.dwcj.addons.markdown.Markdown;
import org.dwcj.component.AbstractComponent;
import org.dwcj.component.Component;
import org.dwcj.component.texts.Label;
import org.dwcj.component.window.AbstractWindow;
import org.dwcj.component.window.Panel;

public class DynamicMarkdown
extends Panel {
    private final ArrayList<Component> ctrlList = new ArrayList();

    protected void create(AbstractWindow p) {
        super.create(p);
    }

    public DynamicMarkdown setText(String text) {
        super.setText(text);
        this.redraw(text);
        return this;
    }

    private void redraw(String text) {
        this.clear();
        this.ctrlList.clear();
        while (!text.isBlank()) {
            String block;
            if (text.startsWith("%%%")) {
                AbstractComponent ctrl;
                Class<?> c;
                String l;
                if (text.contains("\n")) {
                    l = text.substring(0, text.indexOf("\n"));
                    text = text.substring(text.indexOf("\n"));
                } else {
                    l = text;
                    text = "";
                }
                l = l.substring(3);
                try {
                    c = Class.forName(l);
                }
                catch (ClassNotFoundException e) {
                    Label lbl = new Label("Class " + l + " not found!");
                    lbl.setStyle("color", "red");
                    this.add(new AbstractComponent[]{lbl});
                    this.ctrlList.add((Component)lbl);
                    continue;
                }
                try {
                    ctrl = (AbstractComponent)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Label lbl = new Label("Class " + l + " cannot be instantiated! Is this a DWCJ control class?");
                    lbl.setStyle("color", "red");
                    this.add(new AbstractComponent[]{lbl});
                    this.ctrlList.add((Component)lbl);
                    continue;
                }
                this.add(new AbstractComponent[]{ctrl});
                this.ctrlList.add((Component)ctrl);
                continue;
            }
            if (text.contains("%%%")) {
                block = text.substring(0, text.indexOf("%%%"));
                text = text.substring(text.indexOf("%%%"));
            } else {
                block = text;
                text = "";
            }
            block = this.resolveGitHub(block);
            while (block.contains("&percnt;&percnt;&percnt;")) {
                block = block.replace("&percnt;&percnt;&percnt;", "%%%");
            }
            Markdown m = new Markdown();
            this.add(new AbstractComponent[]{m});
            m.setText(block);
            this.ctrlList.add((Component)m);
        }
    }

    private String resolveGitHub(String block) {
        String[] lines;
        boolean inCode = false;
        Object result = new String();
        for (String line : lines = block.split("\n")) {
            if (line.startsWith("```")) {
                inCode = !inCode;
                result = (String)result + line + "\n";
                continue;
            }
            if (inCode) {
                result = (String)result + line + "\n";
                continue;
            }
            if (line.startsWith("https://github.com")) {
                result = (String)result + "[" + line + "](" + line + " \"View on GitHub\")\n";
                result = (String)result + "```" + this.guessLanguage(line) + "\n";
                result = (String)result + this.getGitHubSnippet(line) + "\n";
                result = (String)result + "```\n";
                continue;
            }
            result = (String)result + line + "\n";
        }
        return result;
    }

    private String guessLanguage(String line) {
        String[] extensions;
        if (line.contains("#")) {
            line = line.substring(0, line.indexOf("#"));
        }
        if ((extensions = line.split("\\.")).length > 0) {
            return extensions[extensions.length - 1];
        }
        return "";
    }

    private String getGitHubSnippet(String line) {
        String code;
        String anchor = "";
        if (line.contains("#")) {
            anchor = line.substring(line.indexOf("#") + 1);
            line = line.substring(0, line.indexOf("#"));
        }
        line = line.replace("https://github.com/", "https://raw.githubusercontent.com/");
        line = line.replace("/blob", "");
        URL url = null;
        try {
            url = new URL(line);
        }
        catch (MalformedURLException e) {
            return "Error: malformed URL " + line;
        }
        try (InputStream in = url.openStream();){
            byte[] bytes = in.readAllBytes();
            code = new String(bytes);
        }
        catch (IOException e) {
            return "Error reading from URL " + line;
        }
        if (!anchor.isBlank() && anchor.contains("-") && anchor.startsWith("L")) {
            String[] lines = anchor.split("-");
            int line1 = -1;
            int line2 = -1;
            line1 = Integer.parseInt(lines[0].substring(1)) - 1;
            line2 = Integer.parseInt(lines[1].substring(1)) - 1;
            if (line1 > 0 && line2 > 0) {
                String[] whole = code.split("\n");
                StringWriter wr = new StringWriter();
                if (whole.length >= line2 && whole.length >= line1) {
                    for (int i = Math.min(line1, line2); i < Math.max(line1, line2); ++i) {
                        wr.append(whole[i]);
                        wr.append("\n");
                    }
                    code = wr.toString();
                }
            }
        }
        return code;
    }
}

