/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.addons.markdown;

import java.util.HashSet;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.dwcj.addons.code.Code;
import org.dwcj.component.AbstractComponent;
import org.dwcj.component.htmlcontainer.HtmlContainer;
import org.dwcj.component.window.AbstractWindow;
import org.dwcj.component.window.Panel;
import org.dwcj.environment.ObjectTable;
import org.dwcj.utilities.Assets;

public class Markdown
extends Panel {
    public static final String PRISM_URL = "https://cdn.jsdelivr.net/npm/prismjs@1.29.0/prism.js";
    public static final String PRISM_CSS = "https://cdn.jsdelivr.net/npm/prismjs@1.29.0/themes/prism-tomorrow.min.css";
    public static final String PRISM_LANG_URL = "https://cdn.jsdelivr.net/npm/prismjs@1.29.0/components/prism-%%language%%.min.js";
    public static final String PRISM_TB_URL = "https://cdn.jsdelivr.net/npm/prismjs@1.29.0/plugins/toolbar/prism-toolbar.min.js";
    public static final String PRISM_TB_CSS = "https://cdn.jsdelivr.net/npm/prismjs@1.29.0/plugins/toolbar/prism-toolbar.min.css";
    public static final String PRISM_CLIPBOARD_URL = "https://cdn.jsdelivr.net/npm/prismjs@1.29.0/plugins/copy-to-clipboard/prism-copy-to-clipboard.min.js";
    private HtmlContainer hv;
    private final HashSet<String> loadedLangs = new HashSet();
    private boolean clipboardButtonLoaded = false;
    private HashSet<String> prism_loaded;

    protected void create(AbstractWindow p) {
        super.create(p);
        if (!ObjectTable.contains((String)"PRISM_LOADED")) {
            this.prism_loaded = new HashSet();
            ObjectTable.put((String)"PRISM_LOADED", this.prism_loaded);
        } else {
            this.prism_loaded = (HashSet)ObjectTable.get((String)"PRISM_LOADED");
        }
        this.hv = new HtmlContainer();
        this.add(new AbstractComponent[]{this.hv});
        this.loadPrismLib();
    }

    public Markdown setText(String text) {
        this.loadLanguages(text);
        this.hv.setText(this.getMarkdown(text));
        super.setText(text);
        String scr = "if (typeof Prism != 'undefined'){Prism.highlightAll();}";
        this.hv.executeScript(scr);
        return this;
    }

    private void loadLanguages(String text) {
        String[] langtags = text.split("\n");
        for (int i = 0; i < langtags.length; ++i) {
            if (!langtags[i].startsWith("```") || langtags[i].length() <= 3) continue;
            String lang = langtags[i].substring(3);
            this.addLanguage(lang);
        }
    }

    public Markdown addLanguage(String language) {
        if (Code.isSupportedLanguage((String)language).booleanValue() && !this.loadedLangs.contains(language)) {
            String url = PRISM_LANG_URL.replace("%%language%%", language);
            Object scr = "function whenPrismLoaded (callback) { if (typeof Prism === 'undefined') {setTimeout (function () {whenPrismLoaded (callback);}, 100);} else { callback (); }}";
            this.hv.injectScript((String)scr);
            scr = "function whenPrismLang" + language + "Loaded (callback) { if (typeof Prism.languages." + language + " === 'undefined' || typeof Prism === 'undefined') {setTimeout (function () {whenPrismLang" + language + "Loaded (callback);}, 100);} else { callback (); }}";
            this.hv.injectScript((String)scr);
            scr = "whenPrismLoaded(function() {var link2 =  document.createElement('script');link2.setAttribute('type','module');link2.setAttribute('src','" + url + "');document.head.appendChild(link2);whenPrismLang" + language + "Loaded(function() {Prism.highlightAll();}) });";
            this.hv.executeScript((String)scr);
            this.loadedLangs.add(language);
            if (!this.clipboardButtonLoaded && !this.prism_loaded.contains(PRISM_TB_URL)) {
                scr = "whenPrismLoaded(function() {var link =  document.createElement('script');link.setAttribute('type','module');link.setAttribute('src','https://cdn.jsdelivr.net/npm/prismjs@1.29.0/plugins/toolbar/prism-toolbar.min.js');document.head.appendChild(link);var csslink =  document.createElement('link');csslink.setAttribute('rel','stylesheet');csslink.setAttribute('href','https://cdn.jsdelivr.net/npm/prismjs@1.29.0/plugins/toolbar/prism-toolbar.min.css');document.head.appendChild(csslink);})";
                this.hv.executeScript((String)scr);
                scr = "whenPrismLoaded(function() {var link =  document.createElement('script');link.setAttribute('type','module');link.setAttribute('src','https://cdn.jsdelivr.net/npm/prismjs@1.29.0/plugins/copy-to-clipboard/prism-copy-to-clipboard.min.js');document.head.appendChild(link);})";
                this.hv.executeScript((String)scr);
                this.clipboardButtonLoaded = true;
                this.prism_loaded.add(PRISM_TB_URL);
            }
        }
        return this;
    }

    private void loadPrismLib() {
        if (!this.prism_loaded.contains(PRISM_URL)) {
            String script = "var link =  document.createElement('script');link.setAttribute('type','module');link.setAttribute('src','https://cdn.jsdelivr.net/npm/prismjs@1.29.0/prism.js');document.head.appendChild(link);var csslink =  document.createElement('link');csslink.setAttribute('rel','stylesheet');csslink.setAttribute('href','https://cdn.jsdelivr.net/npm/prismjs@1.29.0/themes/prism-tomorrow.min.css');document.head.appendChild(csslink);";
            this.hv.executeScript(script);
            this.prism_loaded.add(PRISM_URL);
        }
    }

    private String getMarkdown(String code) {
        Parser parser = Parser.builder().build();
        Node document = parser.parse(code);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        return "<html>" + renderer.render(document);
    }

    public Markdown load(String filepath) {
        this.setText(Assets.contentOf((String)filepath));
        return this;
    }
}

