/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.addons.youtube;

import java.util.HashMap;
import java.util.Map;
import org.dwcj.App;
import org.dwcj.annotation.ExcludeFromJacocoGeneratedReport;
import org.dwcj.annotation.InlineStyleSheet;
import org.dwcj.component.Component;
import org.dwcj.component.element.Element;
import org.dwcj.component.element.ElementComposite;
import org.dwcj.component.element.PropertyDescriptor;
import org.dwcj.component.element.annotation.NodeName;
import org.dwcj.concern.HasAttribute;
import org.dwcj.concern.HasClassName;
import org.dwcj.concern.HasStyle;

@NodeName(value="iframe")
@InlineStyleSheet(id="dwcj-youtube-widget", once=true, value="[dwcj-youtube-container] {\n  width: 100%;\n  /* Keep it the right aspect-ratio */\n  aspect-ratio: 16/9;\n  overflow: hidden !important;\n}\n\n[dwcj-youtube-container] iframe {\n  /* Extend it beyond the viewport... */\n  width: 300%;\n  height: 100%;\n  /* ...and bring it back again */\n  margin-left: -100%;\n}\n")
public class Youtube
extends ElementComposite
implements HasAttribute<Youtube>,
HasClassName<Youtube>,
HasStyle<Youtube> {
    private final PropertyDescriptor<String> srcProp = PropertyDescriptor.property((String)"src", (Object)"");
    private String videoId = "";
    private boolean autoplay = false;
    private String captionLanguage = "en";
    private boolean showCaption = false;
    private boolean controls = true;
    private boolean disableKeyboard = false;
    private int end = 0;
    private boolean fullScreenButton = true;
    private String language = "en";
    private int showAnnotations = 1;
    private String list = "";
    private ListType listType = null;
    private boolean loop = false;
    private boolean modestBranding = false;
    private String playlist = "";
    private boolean playsInline = false;
    private int start = 0;
    private boolean mute = false;

    public Youtube() {
        Element current = this.getElement();
        current.setAttribute("dwcj-youtube", "");
        current.setAttribute("frameborder", "0");
        current.setAttribute("allow", "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture;");
        current.setAttribute("allowfullscreen", "true");
        this.whenAttached().thenAccept(element -> {
            this.updateSrc();
            Element container = new Element();
            container.setAttribute("dwcj-youtube-container", "");
            container.add(new Component[]{this});
            this.getWindow().add(new Component[]{container});
            App.consoleLog((String)"Youtube component added to the window");
        });
    }

    public Youtube(String id) {
        this();
        this.setVideoId(id);
    }

    public Youtube setVideoId(String id) {
        this.videoId = id;
        this.updateSrc();
        return this;
    }

    public String getVideoId() {
        return this.videoId;
    }

    public Youtube setAutoPlay(Boolean autoplay) {
        this.autoplay = autoplay;
        this.updateSrc();
        return this;
    }

    public Boolean isAutoPlay() {
        return this.autoplay;
    }

    public Youtube setCaptionLanguage(String language) {
        this.captionLanguage = language;
        this.updateSrc();
        return this;
    }

    public String getCaptionLanguage() {
        return this.captionLanguage;
    }

    public Youtube setCaption(Boolean showCaption) {
        this.showCaption = showCaption;
        this.updateSrc();
        return this;
    }

    public Boolean isCaption() {
        return this.showCaption;
    }

    public Youtube setControls(Boolean controls) {
        this.controls = controls;
        this.updateSrc();
        return this;
    }

    public Boolean isControls() {
        return this.controls;
    }

    public Youtube setDisableKeyboard(Boolean disableKeyboard) {
        this.disableKeyboard = disableKeyboard;
        this.updateSrc();
        return this;
    }

    public Boolean isDisableKeyboard() {
        return this.disableKeyboard;
    }

    public Youtube setEnd(int end) {
        this.end = end;
        this.updateSrc();
        return this;
    }

    public int getEnd() {
        return this.end;
    }

    public Youtube setFullScreenButton(Boolean fullScreen) {
        this.fullScreenButton = fullScreen;
        this.updateSrc();
        return this;
    }

    public Boolean isFullScreenButton() {
        return this.fullScreenButton;
    }

    public Youtube setLanguage(String language) {
        this.language = language;
        this.updateSrc();
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Youtube setShowAnnotations(Boolean showAnnotations) {
        this.showAnnotations = Boolean.TRUE.equals(showAnnotations) ? 1 : 3;
        this.updateSrc();
        return this;
    }

    public Boolean isShowAnnotations() {
        return this.showAnnotations == 1;
    }

    public Youtube setList(String list) {
        this.list = list;
        this.updateSrc();
        return this;
    }

    public String getList() {
        return this.list;
    }

    public Youtube setListType(ListType listType) {
        this.listType = listType;
        this.updateSrc();
        return this;
    }

    public ListType getListType() {
        return this.listType;
    }

    public Youtube setLoop(Boolean loop) {
        this.loop = loop;
        this.updateSrc();
        return this;
    }

    public Boolean isLoop() {
        return this.loop;
    }

    public Youtube setModestBranding(Boolean modestBranding) {
        this.modestBranding = modestBranding;
        this.updateSrc();
        return this;
    }

    public Boolean isModestBranding() {
        return this.modestBranding;
    }

    public Youtube setPlaylist(String playlist) {
        this.playlist = playlist;
        this.updateSrc();
        return this;
    }

    public String getPlaylist() {
        return this.playlist;
    }

    public Youtube setPlaysInline(Boolean playsinline) {
        this.playsInline = playsinline;
        this.updateSrc();
        return this;
    }

    public Boolean isPlaysInline() {
        return this.playsInline;
    }

    public Youtube setStart(int start) {
        this.start = start;
        this.updateSrc();
        return this;
    }

    public int getStart() {
        return this.start;
    }

    public Youtube setMute(Boolean mute) {
        this.mute = mute;
        this.updateSrc();
        return this;
    }

    public Boolean getMute() {
        return this.mute;
    }

    public String getUrl() {
        Object url = "https://www.youtube.com/embed/" + this.videoId;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("autoplay", this.autoplay ? "1" : "0");
        params.put("cc_load_policy", this.showCaption ? "1" : "0");
        params.put("controls", this.controls ? "1" : "0");
        params.put("disablekb", this.disableKeyboard ? "1" : "0");
        params.put("fs", this.fullScreenButton ? "1" : "0");
        params.put("iv_load_policy", String.valueOf(this.showAnnotations));
        params.put("loop", this.loop ? "1" : "0");
        params.put("modestbranding", this.modestBranding ? "1" : "0");
        params.put("playsinline", this.playsInline ? "1" : "0");
        params.put("mute", this.mute ? "1" : "0");
        if (this.captionLanguage != null && !this.captionLanguage.isEmpty()) {
            params.put("cc_lang_pref", this.captionLanguage);
        }
        if (this.end > 0) {
            params.put("end", String.valueOf(this.end));
        }
        if (this.start > 0) {
            params.put("start", String.valueOf(this.start));
        }
        if (this.language != null && !this.language.isEmpty()) {
            params.put("hl", this.language);
        }
        if (this.list != null && !this.list.isEmpty()) {
            params.put("list", this.list);
        }
        if (this.listType != null) {
            params.put("listType", this.listType.getValue());
        }
        if (this.playlist != null && !this.playlist.isEmpty()) {
            params.put("playlist", this.playlist);
        }
        if (!params.isEmpty()) {
            StringBuilder builder = new StringBuilder((String)url + "?");
            for (Map.Entry entry : params.entrySet()) {
                builder.append((String)entry.getKey() + "=" + (String)entry.getValue() + "&");
            }
            url = builder.toString();
        }
        return url;
    }

    @ExcludeFromJacocoGeneratedReport
    public Youtube addClassName(String ... className) {
        this.getElement().addClassName(className);
        return this;
    }

    @ExcludeFromJacocoGeneratedReport
    public Youtube removeClassName(String ... className) {
        this.getElement().removeClassName(className);
        return this;
    }

    @ExcludeFromJacocoGeneratedReport
    public Youtube setStyle(String property, String value) {
        this.getElement().setStyle(property, value);
        return this;
    }

    @ExcludeFromJacocoGeneratedReport
    public String getStyle(String property) {
        return this.getElement().getStyle(property);
    }

    @ExcludeFromJacocoGeneratedReport
    public Youtube removeStyle(String property) {
        this.getElement().removeStyle(property);
        return this;
    }

    @ExcludeFromJacocoGeneratedReport
    public String getComputedStyle(String property) {
        return this.getElement().getComputedStyle(property);
    }

    @ExcludeFromJacocoGeneratedReport
    public String getAttribute(String attribute) {
        return this.getElement().getAttribute(attribute);
    }

    @ExcludeFromJacocoGeneratedReport
    public Youtube setAttribute(String attribute, String value) {
        this.getElement().setAttribute(attribute, value);
        return this;
    }

    @ExcludeFromJacocoGeneratedReport
    public Youtube removeAttribute(String attribute) {
        this.getElement().removeAttribute(attribute);
        return this;
    }

    private void updateSrc() {
        if (!this.isAttached()) {
            return;
        }
        if (Boolean.TRUE.equals(this.isControls())) {
            this.setStyle("pointer-events", "auto");
        } else {
            this.setStyle("pointer-events", "none");
        }
        this.set(this.srcProp, this.getUrl());
    }

    public static enum ListType {
        USER_UPLOADS("user_uploads"),
        PLAYLIST("playlist");

        private String value;

        private ListType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ListType fromValue(String value) {
            for (ListType list : ListType.values()) {
                if (!list.getValue().equals(value)) continue;
                return list;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

