/*
 * Decompiled with CFR 0.152.
 */
package org.dx42.kibosh.rule;

import org.dx42.kibosh.rule.Rule;

public final class Violation {
    private final Rule rule;
    private final String message;
    private final int lineNumber;

    Violation(Rule rule, String message, int lineNumber) {
        this.rule = rule;
        this.message = message;
        this.lineNumber = lineNumber;
    }

    public static ViolationBuilder builder() {
        return new ViolationBuilder();
    }

    public Rule getRule() {
        return this.rule;
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Violation)) {
            return false;
        }
        Violation other = (Violation)o;
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumber();
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "Violation(rule=" + String.valueOf(this.getRule()) + ", message=" + this.getMessage() + ", lineNumber=" + this.getLineNumber() + ")";
    }

    public static class ViolationBuilder {
        private Rule rule;
        private String message;
        private int lineNumber;

        ViolationBuilder() {
        }

        public ViolationBuilder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public ViolationBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ViolationBuilder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Violation build() {
            return new Violation(this.rule, this.message, this.lineNumber);
        }

        public String toString() {
            return "Violation.ViolationBuilder(rule=" + String.valueOf(this.rule) + ", message=" + this.message + ", lineNumber=" + this.lineNumber + ")";
        }
    }
}

