/*
 * Decompiled with CFR 0.152.
 */
package org.dx42.kibosh.runner;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.dx42.kibosh.rule.Rule;
import org.dx42.kibosh.runner.KiboshFileVisitor;
import org.dx42.kibosh.runner.KiboshViolationsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiboshRunner {
    private static final Logger log = LoggerFactory.getLogger(KiboshRunner.class);
    private final String baseDirectory;

    public void applyRules(List<Rule> rules) {
        Path startingDir = Paths.get(this.baseDirectory, new String[0]);
        KiboshFileVisitor visitor = new KiboshFileVisitor(rules);
        Files.walkFileTree(startingDir, visitor);
        if (!visitor.getViolations().isEmpty()) {
            String violationsOnePerLine = visitor.getViolations().stream().map(v -> "- " + v.getMessage()).collect(Collectors.joining("\n    "));
            log.error("There were violations: \n    {}", (Object)violationsOnePerLine);
            throw new KiboshViolationsException(visitor.getViolations());
        }
    }

    KiboshRunner(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public static KiboshRunnerBuilder builder() {
        return new KiboshRunnerBuilder();
    }

    public static class KiboshRunnerBuilder {
        private String baseDirectory;

        KiboshRunnerBuilder() {
        }

        public KiboshRunnerBuilder baseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public KiboshRunner build() {
            return new KiboshRunner(this.baseDirectory);
        }

        public String toString() {
            return "KiboshRunner.KiboshRunnerBuilder(baseDirectory=" + this.baseDirectory + ")";
        }
    }
}

