/*
 * Decompiled with CFR 0.152.
 */
package org.dx42.kibosh.rule;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dx42.kibosh.rule.Rule;
import org.dx42.kibosh.rule.Violation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextRule
implements Rule {
    private static final Logger log = LoggerFactory.getLogger(TextRule.class);
    private static final String QUOTES = "\"";
    protected static Function<Path, String> readFile = TextRule::readFileContents;
    private final String name;
    private final String description;
    private Violation.Severity severity;
    List<String> illegalStrings;
    List<String> illegalRegularExpressions;
    List<String> requiredStrings;
    List<String> requiredRegularExpressions;
    List<String> excludeFilenames;
    private final Map<String, Pattern> illegalRegularExpressionPatterns = new LinkedHashMap<String, Pattern>();

    @Override
    public List<Violation> applyToFile(Path path) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        if (this.shouldExcludeFile(path)) {
            return violations;
        }
        String fileContents = readFile.apply(path);
        this.checkForIllegalStrings(path, fileContents, violations);
        this.checkForIllegalRegularExpressions(path, fileContents, violations);
        this.checkForRequiredStrings(path, fileContents, violations);
        this.checkForRequiredRegularExpressions(path, fileContents, violations);
        return violations;
    }

    private boolean shouldExcludeFile(Path path) {
        for (String excludeFilename : this.excludeFilenames) {
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + excludeFilename);
            if (!pathMatcher.matches(path.getFileName())) continue;
            return true;
        }
        return false;
    }

    private void checkForIllegalStrings(Path path, String fileContents, List<Violation> violations) {
        for (String illegalString : this.illegalStrings) {
            if (!fileContents.contains(illegalString)) continue;
            String message = this.messagePrefix(path) + "contains illegal string " + this.quoted(illegalString);
            this.addViolation(violations, message);
        }
    }

    private void checkForIllegalRegularExpressions(Path path, String fileContents, List<Violation> violations) {
        for (String illegalRegex : this.illegalRegularExpressions) {
            Pattern pattern = this.patternForRegex(illegalRegex);
            Matcher matcher = pattern.matcher(fileContents);
            if (!matcher.find()) continue;
            String message = this.messagePrefix(path) + "contains illegal regular expression /" + illegalRegex + "/";
            this.addViolation(violations, message);
        }
    }

    private void checkForRequiredStrings(Path path, String fileContents, List<Violation> violations) {
        for (String requiredString : this.requiredStrings) {
            if (fileContents.contains(requiredString)) continue;
            String message = this.messagePrefix(path) + "does not contain required string " + this.quoted(requiredString);
            this.addViolation(violations, message);
        }
    }

    private void checkForRequiredRegularExpressions(Path path, String fileContents, List<Violation> violations) {
        for (String requiredRegex : this.requiredRegularExpressions) {
            Pattern pattern = this.patternForRegex(requiredRegex);
            Matcher matcher = pattern.matcher(fileContents);
            if (matcher.find()) continue;
            String message = this.messagePrefix(path) + "does not contain required regular expression /" + requiredRegex + "/";
            this.addViolation(violations, message);
        }
    }

    private String messagePrefix(Path path) {
        return this.name + ": " + this.quoted(this.description) + "; File=.(" + path.getFileName() + ":1) ";
    }

    private Pattern patternForRegex(String regex) {
        if (!this.illegalRegularExpressionPatterns.containsKey(regex)) {
            this.illegalRegularExpressionPatterns.put(regex, Pattern.compile(regex));
        }
        return this.illegalRegularExpressionPatterns.get(regex);
    }

    private void addViolation(List<Violation> violations, String message) {
        Violation violation = Violation.builder().rule(this).severity(this.severity).message(message).build();
        violations.add(violation);
    }

    private String quoted(String string) {
        return QUOTES + string + QUOTES;
    }

    private static String readFileContents(Path path) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Violation.Severity $default$severity() {
        return Violation.Severity.ERROR;
    }

    TextRule(String name, String description, Violation.Severity severity, List<String> illegalStrings, List<String> illegalRegularExpressions, List<String> requiredStrings, List<String> requiredRegularExpressions, List<String> excludeFilenames) {
        this.name = name;
        this.description = description;
        this.severity = severity;
        this.illegalStrings = illegalStrings;
        this.illegalRegularExpressions = illegalRegularExpressions;
        this.requiredStrings = requiredStrings;
        this.requiredRegularExpressions = requiredRegularExpressions;
        this.excludeFilenames = excludeFilenames;
    }

    public static TextRuleBuilder builder() {
        return new TextRuleBuilder();
    }

    public static class TextRuleBuilder {
        private String name;
        private String description;
        private boolean severity$set;
        private Violation.Severity severity$value;
        private ArrayList<String> illegalStrings;
        private ArrayList<String> illegalRegularExpressions;
        private ArrayList<String> requiredStrings;
        private ArrayList<String> requiredRegularExpressions;
        private ArrayList<String> excludeFilenames;

        TextRuleBuilder() {
        }

        public TextRuleBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TextRuleBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TextRuleBuilder severity(Violation.Severity severity) {
            this.severity$value = severity;
            this.severity$set = true;
            return this;
        }

        public TextRuleBuilder illegalString(String illegalString) {
            if (this.illegalStrings == null) {
                this.illegalStrings = new ArrayList();
            }
            this.illegalStrings.add(illegalString);
            return this;
        }

        public TextRuleBuilder illegalStrings(Collection<? extends String> illegalStrings) {
            if (illegalStrings == null) {
                throw new NullPointerException("illegalStrings cannot be null");
            }
            if (this.illegalStrings == null) {
                this.illegalStrings = new ArrayList();
            }
            this.illegalStrings.addAll(illegalStrings);
            return this;
        }

        public TextRuleBuilder clearIllegalStrings() {
            if (this.illegalStrings != null) {
                this.illegalStrings.clear();
            }
            return this;
        }

        public TextRuleBuilder illegalRegularExpression(String illegalRegularExpression) {
            if (this.illegalRegularExpressions == null) {
                this.illegalRegularExpressions = new ArrayList();
            }
            this.illegalRegularExpressions.add(illegalRegularExpression);
            return this;
        }

        public TextRuleBuilder illegalRegularExpressions(Collection<? extends String> illegalRegularExpressions) {
            if (illegalRegularExpressions == null) {
                throw new NullPointerException("illegalRegularExpressions cannot be null");
            }
            if (this.illegalRegularExpressions == null) {
                this.illegalRegularExpressions = new ArrayList();
            }
            this.illegalRegularExpressions.addAll(illegalRegularExpressions);
            return this;
        }

        public TextRuleBuilder clearIllegalRegularExpressions() {
            if (this.illegalRegularExpressions != null) {
                this.illegalRegularExpressions.clear();
            }
            return this;
        }

        public TextRuleBuilder requiredString(String requiredString) {
            if (this.requiredStrings == null) {
                this.requiredStrings = new ArrayList();
            }
            this.requiredStrings.add(requiredString);
            return this;
        }

        public TextRuleBuilder requiredStrings(Collection<? extends String> requiredStrings) {
            if (requiredStrings == null) {
                throw new NullPointerException("requiredStrings cannot be null");
            }
            if (this.requiredStrings == null) {
                this.requiredStrings = new ArrayList();
            }
            this.requiredStrings.addAll(requiredStrings);
            return this;
        }

        public TextRuleBuilder clearRequiredStrings() {
            if (this.requiredStrings != null) {
                this.requiredStrings.clear();
            }
            return this;
        }

        public TextRuleBuilder requiredRegularExpression(String requiredRegularExpression) {
            if (this.requiredRegularExpressions == null) {
                this.requiredRegularExpressions = new ArrayList();
            }
            this.requiredRegularExpressions.add(requiredRegularExpression);
            return this;
        }

        public TextRuleBuilder requiredRegularExpressions(Collection<? extends String> requiredRegularExpressions) {
            if (requiredRegularExpressions == null) {
                throw new NullPointerException("requiredRegularExpressions cannot be null");
            }
            if (this.requiredRegularExpressions == null) {
                this.requiredRegularExpressions = new ArrayList();
            }
            this.requiredRegularExpressions.addAll(requiredRegularExpressions);
            return this;
        }

        public TextRuleBuilder clearRequiredRegularExpressions() {
            if (this.requiredRegularExpressions != null) {
                this.requiredRegularExpressions.clear();
            }
            return this;
        }

        public TextRuleBuilder excludeFilename(String excludeFilename) {
            if (this.excludeFilenames == null) {
                this.excludeFilenames = new ArrayList();
            }
            this.excludeFilenames.add(excludeFilename);
            return this;
        }

        public TextRuleBuilder excludeFilenames(Collection<? extends String> excludeFilenames) {
            if (excludeFilenames == null) {
                throw new NullPointerException("excludeFilenames cannot be null");
            }
            if (this.excludeFilenames == null) {
                this.excludeFilenames = new ArrayList();
            }
            this.excludeFilenames.addAll(excludeFilenames);
            return this;
        }

        public TextRuleBuilder clearExcludeFilenames() {
            if (this.excludeFilenames != null) {
                this.excludeFilenames.clear();
            }
            return this;
        }

        public TextRule build() {
            List<String> excludeFilenames;
            List<String> requiredRegularExpressions;
            List<String> requiredStrings;
            List<String> illegalRegularExpressions;
            List<String> illegalStrings;
            switch (this.illegalStrings == null ? 0 : this.illegalStrings.size()) {
                case 0: {
                    illegalStrings = Collections.emptyList();
                    break;
                }
                case 1: {
                    illegalStrings = Collections.singletonList(this.illegalStrings.get(0));
                    break;
                }
                default: {
                    illegalStrings = Collections.unmodifiableList(new ArrayList<String>(this.illegalStrings));
                }
            }
            switch (this.illegalRegularExpressions == null ? 0 : this.illegalRegularExpressions.size()) {
                case 0: {
                    illegalRegularExpressions = Collections.emptyList();
                    break;
                }
                case 1: {
                    illegalRegularExpressions = Collections.singletonList(this.illegalRegularExpressions.get(0));
                    break;
                }
                default: {
                    illegalRegularExpressions = Collections.unmodifiableList(new ArrayList<String>(this.illegalRegularExpressions));
                }
            }
            switch (this.requiredStrings == null ? 0 : this.requiredStrings.size()) {
                case 0: {
                    requiredStrings = Collections.emptyList();
                    break;
                }
                case 1: {
                    requiredStrings = Collections.singletonList(this.requiredStrings.get(0));
                    break;
                }
                default: {
                    requiredStrings = Collections.unmodifiableList(new ArrayList<String>(this.requiredStrings));
                }
            }
            switch (this.requiredRegularExpressions == null ? 0 : this.requiredRegularExpressions.size()) {
                case 0: {
                    requiredRegularExpressions = Collections.emptyList();
                    break;
                }
                case 1: {
                    requiredRegularExpressions = Collections.singletonList(this.requiredRegularExpressions.get(0));
                    break;
                }
                default: {
                    requiredRegularExpressions = Collections.unmodifiableList(new ArrayList<String>(this.requiredRegularExpressions));
                }
            }
            switch (this.excludeFilenames == null ? 0 : this.excludeFilenames.size()) {
                case 0: {
                    excludeFilenames = Collections.emptyList();
                    break;
                }
                case 1: {
                    excludeFilenames = Collections.singletonList(this.excludeFilenames.get(0));
                    break;
                }
                default: {
                    excludeFilenames = Collections.unmodifiableList(new ArrayList<String>(this.excludeFilenames));
                }
            }
            Violation.Severity severity$value = this.severity$value;
            if (!this.severity$set) {
                severity$value = TextRule.$default$severity();
            }
            return new TextRule(this.name, this.description, severity$value, illegalStrings, illegalRegularExpressions, requiredStrings, requiredRegularExpressions, excludeFilenames);
        }

        public String toString() {
            return "TextRule.TextRuleBuilder(name=" + this.name + ", description=" + this.description + ", severity$value=" + (Object)((Object)this.severity$value) + ", illegalStrings=" + this.illegalStrings + ", illegalRegularExpressions=" + this.illegalRegularExpressions + ", requiredStrings=" + this.requiredStrings + ", requiredRegularExpressions=" + this.requiredRegularExpressions + ", excludeFilenames=" + this.excludeFilenames + ")";
        }
    }
}

