/*
 * Decompiled with CFR 0.152.
 */
package org.dx42.kibosh.runner;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dx42.kibosh.rule.Rule;
import org.dx42.kibosh.rule.Violation;
import org.dx42.kibosh.runner.KiboshFileVisitor;
import org.dx42.kibosh.runner.KiboshViolationsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiboshRunner {
    private static final Logger log = LoggerFactory.getLogger(KiboshRunner.class);
    private final List<String> baseDirectories;
    private final String applyToFileNames;

    public void applyRules(List<Rule> rules) {
        KiboshFileVisitor visitor = new KiboshFileVisitor(rules, "glob:" + this.fileNamePattern());
        this.walkFileTree(visitor);
        this.checkForViolations(visitor);
    }

    public void applyRules(Rule ... rules) {
        this.applyRules(Arrays.asList(rules));
    }

    private void walkFileTree(KiboshFileVisitor visitor) throws IOException {
        for (String baseDirectory : this.baseDirectories) {
            Path startingDir = Paths.get(baseDirectory, new String[0]);
            Files.walkFileTree(startingDir, visitor);
        }
    }

    private void checkForViolations(KiboshFileVisitor visitor) {
        List<Violation> warningViolations = KiboshRunner.getViolationsBySeverity(visitor.getViolations(), Violation.Severity.WARNING);
        KiboshRunner.logViolations(warningViolations, Violation.Severity.WARNING);
        List<Violation> errorViolations = KiboshRunner.getViolationsBySeverity(visitor.getViolations(), Violation.Severity.ERROR);
        KiboshRunner.logViolations(errorViolations, Violation.Severity.ERROR);
        if (!errorViolations.isEmpty()) {
            throw new KiboshViolationsException(errorViolations);
        }
    }

    private String fileNamePattern() {
        return this.applyToFileNames == null ? "*.java" : this.applyToFileNames;
    }

    private static void logViolations(List<Violation> violations, Violation.Severity severity) {
        if (!violations.isEmpty()) {
            String violationsOnePerLine = violations.stream().map(v -> "- " + v.getMessage()).collect(Collectors.joining("\n    "));
            log.warn("There were {} violations: \n    {}", (Object)(violations.size() + " " + (Object)((Object)severity)), (Object)violationsOnePerLine);
        }
    }

    private static List<Violation> getViolationsBySeverity(List<Violation> violations, Violation.Severity severity) {
        return violations.stream().filter(v -> v.getSeverity() == severity).collect(Collectors.toList());
    }

    KiboshRunner(List<String> baseDirectories, String applyToFileNames) {
        this.baseDirectories = baseDirectories;
        this.applyToFileNames = applyToFileNames;
    }

    public static KiboshRunnerBuilder builder() {
        return new KiboshRunnerBuilder();
    }

    public static class KiboshRunnerBuilder {
        private ArrayList<String> baseDirectories;
        private String applyToFileNames;

        KiboshRunnerBuilder() {
        }

        public KiboshRunnerBuilder baseDirectory(String baseDirectory) {
            if (this.baseDirectories == null) {
                this.baseDirectories = new ArrayList();
            }
            this.baseDirectories.add(baseDirectory);
            return this;
        }

        public KiboshRunnerBuilder baseDirectories(Collection<? extends String> baseDirectories) {
            if (baseDirectories == null) {
                throw new NullPointerException("baseDirectories cannot be null");
            }
            if (this.baseDirectories == null) {
                this.baseDirectories = new ArrayList();
            }
            this.baseDirectories.addAll(baseDirectories);
            return this;
        }

        public KiboshRunnerBuilder clearBaseDirectories() {
            if (this.baseDirectories != null) {
                this.baseDirectories.clear();
            }
            return this;
        }

        public KiboshRunnerBuilder applyToFileNames(String applyToFileNames) {
            this.applyToFileNames = applyToFileNames;
            return this;
        }

        public KiboshRunner build() {
            List<String> baseDirectories;
            switch (this.baseDirectories == null ? 0 : this.baseDirectories.size()) {
                case 0: {
                    baseDirectories = Collections.emptyList();
                    break;
                }
                case 1: {
                    baseDirectories = Collections.singletonList(this.baseDirectories.get(0));
                    break;
                }
                default: {
                    baseDirectories = Collections.unmodifiableList(new ArrayList<String>(this.baseDirectories));
                }
            }
            return new KiboshRunner(baseDirectories, this.applyToFileNames);
        }

        public String toString() {
            return "KiboshRunner.KiboshRunnerBuilder(baseDirectories=" + this.baseDirectories + ", applyToFileNames=" + this.applyToFileNames + ")";
        }
    }
}

