/*
 * Decompiled with CFR 0.152.
 */
package org.dx42.kibosh.rule;

import org.dx42.kibosh.rule.Rule;

public final class Violation {
    private final Rule rule;
    private final String message;
    private final int lineNumber;
    private final Severity severity;

    private static Severity $default$severity() {
        return Severity.ERROR;
    }

    Violation(Rule rule, String message, int lineNumber, Severity severity) {
        this.rule = rule;
        this.message = message;
        this.lineNumber = lineNumber;
        this.severity = severity;
    }

    public static ViolationBuilder builder() {
        return new ViolationBuilder();
    }

    public Rule getRule() {
        return this.rule;
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Violation)) {
            return false;
        }
        Violation other = (Violation)o;
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        return !(this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumber();
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        return result;
    }

    public String toString() {
        return "Violation(rule=" + this.getRule() + ", message=" + this.getMessage() + ", lineNumber=" + this.getLineNumber() + ", severity=" + (Object)((Object)this.getSeverity()) + ")";
    }

    public static enum Severity {
        ERROR,
        WARNING;

    }

    public static class ViolationBuilder {
        private Rule rule;
        private String message;
        private int lineNumber;
        private boolean severity$set;
        private Severity severity$value;

        ViolationBuilder() {
        }

        public ViolationBuilder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public ViolationBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ViolationBuilder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public ViolationBuilder severity(Severity severity) {
            this.severity$value = severity;
            this.severity$set = true;
            return this;
        }

        public Violation build() {
            Severity severity$value = this.severity$value;
            if (!this.severity$set) {
                severity$value = Violation.$default$severity();
            }
            return new Violation(this.rule, this.message, this.lineNumber, severity$value);
        }

        public String toString() {
            return "Violation.ViolationBuilder(rule=" + this.rule + ", message=" + this.message + ", lineNumber=" + this.lineNumber + ", severity$value=" + (Object)((Object)this.severity$value) + ")";
        }
    }
}

