/*
 * Decompiled with CFR 0.152.
 */
package org.dx42.kibosh.runner;

import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.dx42.kibosh.rule.Rule;
import org.dx42.kibosh.rule.Violation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiboshFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger log = LoggerFactory.getLogger(KiboshFileVisitor.class);
    private final List<Rule> rules;
    private final PathMatcher pathMatcher;
    private final List<Violation> violations = new ArrayList<Violation>();

    public KiboshFileVisitor(List<Rule> rules, String fileNamePattern) {
        this.rules = rules;
        this.pathMatcher = FileSystems.getDefault().getPathMatcher(fileNamePattern);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (this.pathMatcher.matches(file.getFileName())) {
            this.rules.forEach(rule -> this.violations.addAll(rule.applyToFile(file)));
        }
        return FileVisitResult.CONTINUE;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }
}

