/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.innerclass;

import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker {
    private final Class<?> declaringClass;
    private final String innerClassName;

    Invoker(Class<?> declaringClass, String innerClassName) {
        this.declaringClass = declaringClass;
        this.innerClassName = innerClassName;
    }

    public Class<?> get() {
        String namespace = this.declaringClass.getName();
        Class<?>[] classArray = this.declaringClass.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> innerClass = classArray[n2];
            if (innerClass.getName().equals(this.expectedInnerClassName(namespace))) {
                return innerClass;
            }
            ++n2;
        }
        return null;
    }

    private String expectedInnerClassName(String namespace) {
        return Strings.concat((Object[])new Object[]{namespace, "$", this.innerClassName});
    }
}

