/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.constructor;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.util.Accessibles;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Invoker<T> {
    private final Constructor<T> constructor;

    Invoker(Class<T> target, Class<?> ... parameterTypes) {
        this.constructor = this.constructor(target, parameterTypes);
    }

    private Constructor<T> constructor(Class<T> target, Class<?> ... parameterTypes) {
        try {
            return target.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find constructor in type ", target.getName(), " with parameter types ", Arrays.toString(parameterTypes)}), e);
        }
    }

    public T newInstance(Object ... args) {
        boolean accessible = this.constructor.isAccessible();
        try {
            T newInstance;
            Accessibles.makeAccessible(this.constructor);
            T t = newInstance = this.constructor.newInstance(args);
            return t;
        }
        catch (Exception e) {
            throw new ReflectionError("Unable to create a new object from the enclosed constructor", e);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.constructor, accessible);
        }
    }

    public Constructor<T> info() {
        return this.constructor;
    }
}

