/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.testng.listener;

import java.util.ArrayList;
import java.util.List;
import org.fest.util.Strings;
import org.testng.ITestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ScreenshotFileNameGenerator {
    private static final String NULL_PARAMETER_VALUE = "[null]";

    static String screenshotFileNameFrom(ITestResult result) {
        List<String> parts = ScreenshotFileNameGenerator.namePartsFrom(result);
        return Strings.join((String[])parts.toArray(new String[parts.size()])).with(".");
    }

    private static List<String> namePartsFrom(ITestResult result) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(result.getTestClass().getName());
        parts.add(result.getMethod().getMethodName());
        ScreenshotFileNameGenerator.addParameters(result, parts);
        parts.add("png");
        return parts;
    }

    private static void addParameters(ITestResult result, List<String> parts) {
        Object[] parameters = result.getParameters();
        if (parameters == null) {
            return;
        }
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object parameter = objectArray[n2];
            parts.add(parameter != null ? parameter.toString() : NULL_PARAMETER_VALUE);
            ++n2;
        }
    }

    private ScreenshotFileNameGenerator() {
    }
}

