/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.testng.listener;

import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.swing.annotation.GUITestFinder;
import org.fest.swing.image.ImageException;
import org.fest.swing.image.ScreenshotTaker;
import org.fest.swing.testng.listener.AbstractTestListener;
import org.fest.swing.testng.listener.ScreenshotFileNameGenerator;
import org.fest.util.Strings;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;

public class ScreenshotOnFailureListener
extends AbstractTestListener {
    private static Logger logger = Logger.getAnonymousLogger();
    private ScreenshotTaker screenshotTaker;
    private String output;
    private boolean ready;

    public ScreenshotOnFailureListener() {
        try {
            this.screenshotTaker = new ScreenshotTaker();
        }
        catch (ImageException e) {
            logger.log(Level.SEVERE, "Unable to create ScreenshotTaker", e);
        }
    }

    String output() {
        return this.output;
    }

    public void onStart(ITestContext context) {
        this.output = context.getOutputDirectory();
        logger.info(Strings.concat((Object[])new Object[]{"TestNG output directory: ", Strings.quote((String)this.output)}));
        this.ready = !Strings.isEmpty((String)this.output) && this.screenshotTaker != null;
    }

    public void onTestFailure(ITestResult result) {
        if (!this.ready || !ScreenshotOnFailureListener.isGUITest(result)) {
            return;
        }
        String screenshotFileName = this.takeScreenshotAndReturnFileName(result);
        if (Strings.isEmpty((String)screenshotFileName)) {
            return;
        }
        logger.info(Strings.concat((Object[])new Object[]{"Screenshot of desktop saved as: ", Strings.quote((String)screenshotFileName)}));
        Reporter.setCurrentTestResult((ITestResult)result);
        Reporter.log((String)Strings.concat((Object[])new Object[]{"<a href=\"", screenshotFileName, "\">Screenshot</a>"}));
    }

    private static boolean isGUITest(ITestResult testResult) {
        Class realClass = testResult.getTestClass().getRealClass();
        Method testMethod = testResult.getMethod().getMethod();
        return GUITestFinder.isGUITest((Class)realClass, (Method)testMethod);
    }

    private String takeScreenshotAndReturnFileName(ITestResult result) {
        String imageName = ScreenshotFileNameGenerator.screenshotFileNameFrom(result);
        String imagePath = Strings.concat((Object[])new Object[]{this.output, File.separator, imageName});
        try {
            this.screenshotTaker.saveDesktopAsPng(imagePath);
        }
        catch (ImageException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        return imageName;
    }
}

