/*
 * Decompiled with CFR 0.152.
 */
package org.fest.test;

import org.fest.test.CodeToTest;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpectedFailure {
    private final Class<? extends Throwable> errorType;

    public static ExpectedFailure expect(Class<? extends Throwable> errorType) {
        return new ExpectedFailure(errorType);
    }

    public static Message expectAssertionError(String message) {
        return new ExpectedFailure(AssertionError.class).withMessage(message);
    }

    public Message withMessage(String message) {
        return new Message(this.errorType, message);
    }

    private ExpectedFailure(Class<? extends Throwable> error) {
        this.errorType = error;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Message {
        private final Class<? extends Throwable> errorType;
        private final String message;

        Message(Class<? extends Throwable> errorType, String message) {
            this.errorType = errorType;
            this.message = message;
        }

        public void on(CodeToTest codeToTest) {
            block3: {
                try {
                    codeToTest.run();
                    this.fail(Strings.concat((Object[])new Object[]{"Expecting a thrown exception of type:<", this.errorTypeName(), ">"}));
                }
                catch (Throwable t) {
                    if (!this.errorType.isInstance(t)) {
                        this.fail(Strings.concat((Object[])new Object[]{"Expecting exception of type:<", this.errorTypeName(), "> but was:<", t.getClass().getName(), ">"}));
                    }
                    if (Objects.areEqual((Object)this.message, (Object)t.getMessage())) break block3;
                    this.fail(Strings.concat((Object[])new Object[]{"Expecting message:<", Strings.quote((String)this.message), "> but was:<", Strings.quote((String)t.getMessage()), ">"}));
                }
            }
        }

        private String errorTypeName() {
            return this.errorType.getName();
        }

        private void fail(String failureMessage) {
            throw new AssertionError((Object)failureMessage);
        }
    }
}

