/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.core;

import java.util.List;
import org.easywatermark.core.CustomDraw;
import org.easywatermark.core.EasyWatermarkHandler;
import org.easywatermark.core.config.FontConfig;
import org.easywatermark.core.config.WatermarkConfig;
import org.easywatermark.core.font.FontProvider;
import org.easywatermark.core.graphics.GraphicsProvider;
import org.easywatermark.entity.Point;
import org.easywatermark.entity.WatermarkBox;
import org.easywatermark.enums.CenterLocationTypeEnum;
import org.easywatermark.enums.EasyWatermarkTypeEnum;
import org.easywatermark.enums.WatermarkTypeEnum;
import org.easywatermark.exception.EasyWatermarkException;
import org.easywatermark.exception.ImageWatermarkHandlerException;
import org.easywatermark.exception.WatermarkHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatermarkHandler<F, G>
implements EasyWatermarkHandler,
FontProvider,
GraphicsProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractWatermarkHandler.class);
    protected String watermarkText;
    protected List<String> watermarkTextList;
    protected byte[] watermarkImage;
    protected F font;
    protected G graphics;
    protected FontConfig fontConfig;
    protected WatermarkConfig watermarkConfig;
    protected CustomDraw customDraw;

    public AbstractWatermarkHandler(byte[] data, FontConfig fontConfig, WatermarkConfig watermarkConfig) {
        this.loadFile(data);
        this.fontConfig = fontConfig;
        this.watermarkConfig = watermarkConfig;
    }

    protected abstract void initGraphics();

    protected abstract void initFont();

    protected abstract void initEnvironment();

    protected abstract float getFileWidth(int var1);

    protected abstract float getFileHeight(int var1);

    protected abstract float getWatermarkImageWidth();

    protected abstract float getWatermarkImageHeight();

    protected abstract byte[] export(EasyWatermarkTypeEnum var1);

    public void setCustomDraw(CustomDraw customDraw) {
        this.customDraw = customDraw;
    }

    public void watermark(String watermarkText) {
        this.watermarkText = watermarkText;
    }

    public void watermark(byte[] watermarkImage) {
        this.watermarkImage = watermarkImage;
    }

    public void watermark(List<String> watermarkTextList) {
        this.watermarkTextList = watermarkTextList;
    }

    @Override
    public byte[] execute(EasyWatermarkTypeEnum watermarkType) {
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Add watermark. Watermark type:{}", (Object)watermarkType);
        }
        switch (watermarkType) {
            case CUSTOM: {
                this.customDraw(this.customDraw);
                break;
            }
            case CENTER: {
                this.drawCenterWatermark();
                break;
            }
            case DIAGONAL: {
                this.drawDiagonalWatermark();
                break;
            }
            case OVERSPREAD: {
                this.drawOverspreadWatermark();
                break;
            }
            default: {
                throw new ImageWatermarkHandlerException("Unsupported watermark type.");
            }
        }
        byte[] res = this.export(watermarkType);
        log.info("Add watermark success.");
        return res;
    }

    private void init() {
        try {
            this.initFont();
            this.initGraphics();
            this.initEnvironment();
            log.info("{} init success,watermark is {}", (Object)this.getClass().getSimpleName(), (Object)this.getWatermarkType());
        }
        catch (Exception e) {
            log.error("Init error.", (Throwable)e);
            throw new EasyWatermarkException("Init error.", e);
        }
    }

    protected WatermarkTypeEnum getWatermarkType() {
        if (this.watermarkText != null) {
            return WatermarkTypeEnum.SINGLE_TEXT;
        }
        if (this.watermarkTextList != null) {
            return WatermarkTypeEnum.MULTI_TEXT;
        }
        return WatermarkTypeEnum.IMAGE;
    }

    protected Point calcCenterWatermarkPoint(float watermarkWidth, float watermarkHeight, int page) {
        float y;
        float x;
        CenterLocationTypeEnum centerLocationType = this.watermarkConfig.getCenterLocationType();
        switch (centerLocationType) {
            case VERTICAL_CENTER: {
                x = (this.getFileWidth(page) - watermarkWidth) / 2.0f;
                y = (this.getFileHeight(page) - watermarkHeight) / 2.0f;
                break;
            }
            case TOP_CENTER: {
                x = (this.getFileWidth(page) - watermarkWidth) / 2.0f;
                y = 0.0f;
                break;
            }
            case BOTTOM_CENTER: {
                x = (this.getFileWidth(page) - watermarkWidth) / 2.0f;
                y = this.getFileHeight(page) - watermarkHeight;
                break;
            }
            case LEFT_CENTER: {
                x = 0.0f;
                y = (this.getFileHeight(page) - watermarkHeight) / 2.0f;
                break;
            }
            case RIGHT_CENTER: {
                x = this.getFileWidth(page) - watermarkWidth;
                y = (this.getFileHeight(page) - watermarkHeight) / 2.0f;
                break;
            }
            default: {
                throw new EasyWatermarkException("Unsupported center watermark type.");
            }
        }
        return new Point(x, y);
    }

    protected Point calcCenterWatermarkPoint(String watermarkText, int page) {
        return this.calcCenterWatermarkPoint(this.getStringWidth(watermarkText), this.getStringHeight(), page);
    }

    @Override
    public WatermarkBox getStringBox(String ... text) {
        if (text.length == 0) {
            throw new NullPointerException("Text is null.");
        }
        if (text.length == 1) {
            return new WatermarkBox(this.getStringWidth(text[0]), this.getStringHeight());
        }
        float width = 0.0f;
        float height = 0.0f;
        for (String s : text) {
            width = Math.max(width, this.getStringWidth(s));
            height += this.getStringHeight();
        }
        return new WatermarkBox(width, height);
    }

    protected float calcDistanceBetweenWatermarks(float blank, float k, int count) {
        return (blank + 2.0f * k) / (float)(count + 1);
    }

    protected WatermarkBox getWatermarkBox(WatermarkTypeEnum watermarkType, int page) {
        WatermarkBox watermarkBox;
        switch (watermarkType) {
            case SINGLE_TEXT: {
                watermarkBox = this.getStringBox(this.watermarkText);
                break;
            }
            case MULTI_TEXT: {
                watermarkBox = this.getStringBox(this.watermarkTextList.toArray(new String[0]));
                break;
            }
            case IMAGE: {
                watermarkBox = new WatermarkBox(this.getWatermarkImageWidth(), this.getWatermarkImageHeight());
                break;
            }
            default: {
                throw new WatermarkHandlerException("Unsupported watermark type.");
            }
        }
        if (watermarkBox.getWidth() > this.getFileWidth(page) || watermarkBox.getHeight() > this.getFileHeight(page)) {
            throw new WatermarkHandlerException("Watermark box size is greater than image size.");
        }
        return watermarkBox;
    }
}

