/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easywatermark.core.AbstractWatermarkHandler;
import org.easywatermark.core.CustomDraw;
import org.easywatermark.core.config.FontConfig;
import org.easywatermark.core.config.WatermarkConfig;
import org.easywatermark.core.handler.ImageWatermarkHandler;
import org.easywatermark.core.handler.PdfWatermarkHandler;
import org.easywatermark.enums.EasyWatermarkTypeEnum;
import org.easywatermark.enums.FileTypeEnums;
import org.easywatermark.exception.FileTypeUnSupportException;
import org.easywatermark.exception.LoadFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyWatermark {
    private static final Logger log = LoggerFactory.getLogger(EasyWatermark.class);
    private FileTypeEnums fileTypeEnums;
    private String text;
    private List<String> textList;
    private byte[] imageByte;
    private WatermarkConfig watermarkConfig = new WatermarkConfig();
    private FontConfig fontConfig = new FontConfig();
    private File file;
    private EasyWatermarkTypeEnum watermarkType = EasyWatermarkTypeEnum.CENTER;
    private CustomDraw customDraw;

    private EasyWatermark() {
    }

    public static EasyWatermark create() {
        return new EasyWatermark();
    }

    public EasyWatermark file(File file) {
        this.file = file;
        return this;
    }

    public EasyWatermark text(String text) {
        this.cleanWatermark();
        this.text = text;
        return this;
    }

    public EasyWatermark text(List<String> textList) {
        this.cleanWatermark();
        this.textList = textList;
        return this;
    }

    public EasyWatermark text(String ... text) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, text);
        this.cleanWatermark();
        this.textList = list;
        return this;
    }

    public EasyWatermark image(byte[] imageFile) {
        if (!FileTypeEnums.isImage(imageFile)) {
            throw new LoadFileException("Image file is not support.");
        }
        this.cleanWatermark();
        this.imageByte = imageFile;
        return this;
    }

    public EasyWatermark config(WatermarkConfig watermarkConfig) {
        this.watermarkConfig = watermarkConfig;
        return this;
    }

    public EasyWatermark config(FontConfig fontConfig) {
        this.fontConfig = fontConfig;
        return this;
    }

    public EasyWatermark easyWatermarkType(EasyWatermarkTypeEnum easyWatermarkTypeEnum) {
        this.watermarkType = easyWatermarkTypeEnum;
        return this;
    }

    public EasyWatermark customDraw(CustomDraw customDraw) {
        this.customDraw = customDraw;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] executor() {
        if (this.file == null) {
            throw new LoadFileException("File is null.");
        }
        this.checkParam();
        try (AbstractWatermarkHandler<?, ?> handler = EasyWatermark.load(this.file, this.fontConfig, this.watermarkConfig);){
            if (this.text != null) {
                handler.watermark(this.text);
            } else if (this.textList != null) {
                handler.watermark(this.textList);
            } else {
                handler.watermark(this.imageByte);
            }
            if (this.customDraw != null) {
                handler.setCustomDraw(this.customDraw);
            }
            byte[] byArray = handler.execute(this.watermarkType);
            return byArray;
        }
        catch (IOException e) {
            log.error("Load file error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void checkParam() {
        if (this.file == null) {
            throw new LoadFileException("File is null.");
        }
        if (this.text == null && this.textList == null && this.imageByte == null) {
            throw new NullPointerException("Watermark text or image file is null.");
        }
        if ((this.text != null || this.textList != null) && this.imageByte != null) {
            throw new IllegalArgumentException("Watermark text and image file must not null.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AbstractWatermarkHandler<?, ?> load(File file, FontConfig fontConfig, WatermarkConfig watermarkConfig) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            AbstractWatermarkHandler<?, ?> abstractWatermarkHandler = EasyWatermark.load(inputStream, fontConfig, watermarkConfig);
            return abstractWatermarkHandler;
        }
        catch (Exception e) {
            throw new LoadFileException(e.getMessage(), e);
        }
    }

    public static AbstractWatermarkHandler<?, ?> load(InputStream inputStream, FontConfig fontConfig, WatermarkConfig watermarkConfig) throws IOException {
        int available = inputStream.available();
        byte[] data = new byte[available];
        int read = inputStream.read(data);
        if (read != available) {
            throw new LoadFileException("Part of this data is not read.");
        }
        return EasyWatermark.load(data, fontConfig, watermarkConfig);
    }

    public static AbstractWatermarkHandler<?, ?> load(byte[] bytes, FontConfig fontConfig, WatermarkConfig watermarkConfig) {
        AbstractWatermarkHandler handler;
        switch (FileTypeEnums.parseFileType(bytes)) {
            case PDF: {
                handler = new PdfWatermarkHandler(bytes, fontConfig, watermarkConfig);
                break;
            }
            case IMAGE: {
                handler = new ImageWatermarkHandler(bytes, fontConfig, watermarkConfig);
                break;
            }
            default: {
                log.warn("File type not support.");
                throw new FileTypeUnSupportException("File type not support.");
            }
        }
        return handler;
    }

    private void cleanWatermark() {
        this.text = null;
        this.textList = null;
        this.imageByte = null;
    }

    public FileTypeEnums getFileTypeEnums() {
        return this.fileTypeEnums;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getTextList() {
        return this.textList;
    }

    public byte[] getImageByte() {
        return this.imageByte;
    }

    public WatermarkConfig getWatermarkConfig() {
        return this.watermarkConfig;
    }

    public FontConfig getFontConfig() {
        return this.fontConfig;
    }

    public File getFile() {
        return this.file;
    }

    public EasyWatermarkTypeEnum getWatermarkType() {
        return this.watermarkType;
    }

    public CustomDraw getCustomDraw() {
        return this.customDraw;
    }

    public void setFileTypeEnums(FileTypeEnums fileTypeEnums) {
        this.fileTypeEnums = fileTypeEnums;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    public void setImageByte(byte[] imageByte) {
        this.imageByte = imageByte;
    }

    public void setWatermarkConfig(WatermarkConfig watermarkConfig) {
        this.watermarkConfig = watermarkConfig;
    }

    public void setFontConfig(FontConfig fontConfig) {
        this.fontConfig = fontConfig;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setWatermarkType(EasyWatermarkTypeEnum watermarkType) {
        this.watermarkType = watermarkType;
    }

    public void setCustomDraw(CustomDraw customDraw) {
        this.customDraw = customDraw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasyWatermark)) {
            return false;
        }
        EasyWatermark other = (EasyWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileTypeEnums this$fileTypeEnums = this.getFileTypeEnums();
        FileTypeEnums other$fileTypeEnums = other.getFileTypeEnums();
        if (this$fileTypeEnums == null ? other$fileTypeEnums != null : !((Object)((Object)this$fileTypeEnums)).equals((Object)other$fileTypeEnums)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$textList = this.getTextList();
        List<String> other$textList = other.getTextList();
        if (this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList)) {
            return false;
        }
        if (!Arrays.equals(this.getImageByte(), other.getImageByte())) {
            return false;
        }
        WatermarkConfig this$watermarkConfig = this.getWatermarkConfig();
        WatermarkConfig other$watermarkConfig = other.getWatermarkConfig();
        if (this$watermarkConfig == null ? other$watermarkConfig != null : !((Object)this$watermarkConfig).equals(other$watermarkConfig)) {
            return false;
        }
        FontConfig this$fontConfig = this.getFontConfig();
        FontConfig other$fontConfig = other.getFontConfig();
        if (this$fontConfig == null ? other$fontConfig != null : !((Object)this$fontConfig).equals(other$fontConfig)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        EasyWatermarkTypeEnum this$watermarkType = this.getWatermarkType();
        EasyWatermarkTypeEnum other$watermarkType = other.getWatermarkType();
        if (this$watermarkType == null ? other$watermarkType != null : !((Object)((Object)this$watermarkType)).equals((Object)other$watermarkType)) {
            return false;
        }
        CustomDraw this$customDraw = this.getCustomDraw();
        CustomDraw other$customDraw = other.getCustomDraw();
        return !(this$customDraw == null ? other$customDraw != null : !this$customDraw.equals(other$customDraw));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EasyWatermark;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileTypeEnums $fileTypeEnums = this.getFileTypeEnums();
        result = result * 59 + ($fileTypeEnums == null ? 43 : ((Object)((Object)$fileTypeEnums)).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        result = result * 59 + Arrays.hashCode(this.getImageByte());
        WatermarkConfig $watermarkConfig = this.getWatermarkConfig();
        result = result * 59 + ($watermarkConfig == null ? 43 : ((Object)$watermarkConfig).hashCode());
        FontConfig $fontConfig = this.getFontConfig();
        result = result * 59 + ($fontConfig == null ? 43 : ((Object)$fontConfig).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        EasyWatermarkTypeEnum $watermarkType = this.getWatermarkType();
        result = result * 59 + ($watermarkType == null ? 43 : ((Object)((Object)$watermarkType)).hashCode());
        CustomDraw $customDraw = this.getCustomDraw();
        result = result * 59 + ($customDraw == null ? 43 : $customDraw.hashCode());
        return result;
    }

    public String toString() {
        return "EasyWatermark(fileTypeEnums=" + (Object)((Object)this.getFileTypeEnums()) + ", text=" + this.getText() + ", textList=" + this.getTextList() + ", imageByte=" + Arrays.toString(this.getImageByte()) + ", watermarkConfig=" + this.getWatermarkConfig() + ", fontConfig=" + this.getFontConfig() + ", file=" + this.getFile() + ", watermarkType=" + (Object)((Object)this.getWatermarkType()) + ", customDraw=" + this.getCustomDraw() + ")";
    }
}

