/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.core.handler;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.easywatermark.core.AbstractWatermarkHandler;
import org.easywatermark.core.CustomDraw;
import org.easywatermark.core.config.FontConfig;
import org.easywatermark.core.config.WatermarkConfig;
import org.easywatermark.entity.Point;
import org.easywatermark.entity.WatermarkBox;
import org.easywatermark.enums.CenterLocationTypeEnum;
import org.easywatermark.enums.DiagonalDirectionTypeEnum;
import org.easywatermark.enums.EasyWatermarkTypeEnum;
import org.easywatermark.enums.OverspreadTypeEnum;
import org.easywatermark.enums.WatermarkTypeEnum;
import org.easywatermark.exception.EasyWatermarkException;
import org.easywatermark.exception.ImageWatermarkHandlerException;
import org.easywatermark.exception.LoadFileException;
import org.easywatermark.exception.LoadFontException;
import org.easywatermark.exception.PdfWatermarkHandlerException;
import org.easywatermark.utils.EasyWatermarkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWatermarkHandler
extends AbstractWatermarkHandler<Font, Graphics2D> {
    private static final Logger log = LoggerFactory.getLogger(ImageWatermarkHandler.class);
    private BufferedImage image;
    private FontMetrics fontMetrics;
    private double ascent;
    private int fontHeight;
    private BufferedImage watermarkBufferedImage;

    public ImageWatermarkHandler(byte[] data, FontConfig fontConfig, WatermarkConfig watermarkConfig) {
        super(data, fontConfig, watermarkConfig);
    }

    @Override
    protected void initGraphics() {
        this.graphics = this.image.createGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.watermarkConfig.getAlpha());
        ((Graphics2D)this.graphics).setComposite(alphaComposite);
        ((Graphics2D)this.graphics).setColor(this.watermarkConfig.getColor());
        ((Graphics2D)this.graphics).setFont((Font)this.font);
        ((Graphics2D)this.graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)this.graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)this.graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)this.graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
    }

    @Override
    protected void initFont() {
        try {
            Font font = this.fontConfig.getFontFile() != null ? Font.createFont(0, this.fontConfig.getFontFile()) : new Font(this.fontConfig.getFontName(), this.fontConfig.getFontStyle(), this.fontConfig.getFontSize());
            this.font = font.deriveFont(this.fontConfig.getFontStyle(), this.fontConfig.getFontSize());
        }
        catch (FontFormatException | IOException e) {
            log.error("Load font error. Font file:{}", (Object)this.fontConfig.getFontFile(), (Object)e);
            throw new LoadFontException("Load font error.", e);
        }
    }

    @Override
    protected void initEnvironment() {
        this.fontMetrics = ((Graphics2D)this.graphics).getFontMetrics((Font)this.font);
        this.ascent = this.fontMetrics.getAscent();
        this.fontHeight = this.fontMetrics.getHeight();
        if (log.isDebugEnabled()) {
            log.debug("Image height:{}, width:{}", (Object)Float.valueOf(this.getFileHeight(0)), (Object)Float.valueOf(this.getFileWidth(0)));
        }
        if (this.getWatermarkType() == WatermarkTypeEnum.IMAGE) {
            try {
                this.watermarkBufferedImage = ImageIO.read(new ByteArrayInputStream(this.watermarkImage));
            }
            catch (IOException e) {
                log.warn("Load image error.", (Throwable)e);
                throw new LoadFileException("Load image error.", e);
            }
        }
    }

    @Override
    protected float getFileWidth(int page) {
        return this.image.getWidth();
    }

    @Override
    protected float getFileHeight(int page) {
        return this.image.getHeight();
    }

    @Override
    protected float getWatermarkImageWidth() {
        return this.watermarkBufferedImage.getWidth();
    }

    @Override
    protected float getWatermarkImageHeight() {
        return this.watermarkBufferedImage.getHeight();
    }

    @Override
    public void customDraw(CustomDraw customDraw) {
        if (customDraw == null) {
            log.warn("Custom draw is null.");
            return;
        }
        customDraw.draw(this.font, this.graphics, this.getFileWidth(0), this.getFileHeight(0), this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] export(EasyWatermarkTypeEnum watermarkType) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            boolean writeResult = ImageIO.write((RenderedImage)this.image, "jpeg", outputStream);
            if (writeResult) {
                byte[] byArray = outputStream.toByteArray();
                return byArray;
            }
            throw new ImageWatermarkHandlerException("Write image error.");
        }
        catch (IOException e) {
            throw new EasyWatermarkException("Write image error.", e);
        }
    }

    @Override
    public void drawDiagonalWatermark() {
        double radians = EasyWatermarkUtils.calcRadians(this.getFileWidth(0), this.getFileHeight(0));
        DiagonalDirectionTypeEnum diagonalDirectionType = this.watermarkConfig.getDiagonalDirectionType();
        switch (diagonalDirectionType) {
            case TOP_TO_BOTTOM: {
                break;
            }
            case BOTTOM_TO_TOP: {
                radians = -radians;
                break;
            }
            default: {
                throw new ImageWatermarkHandlerException("Unsupported diagonal watermark type.");
            }
        }
        ((Graphics2D)this.graphics).rotate(radians, (double)this.getFileWidth(0) / 2.0, (double)this.getFileHeight(0) / 2.0);
        WatermarkTypeEnum watermarkType = this.getWatermarkType();
        switch (watermarkType) {
            case SINGLE_TEXT: {
                float x = (this.getFileWidth(0) - this.getStringWidth(this.watermarkText)) / 2.0f;
                float y = (this.getFileHeight(0) - this.getStringHeight()) / 2.0f;
                this.drawString(x, y, this.watermarkText);
                break;
            }
            case MULTI_TEXT: {
                WatermarkBox watermarkBox = this.getWatermarkBox(watermarkType, 0);
                float y = (this.getFileHeight(0) - watermarkBox.getHeight()) / 2.0f;
                for (int i = 0; i < this.watermarkTextList.size(); ++i) {
                    float x = (this.getFileWidth(0) - this.getStringWidth((String)this.watermarkTextList.get(i))) / 2.0f;
                    this.drawString(x, y + (float)i * this.getStringHeight(), (String)this.watermarkTextList.get(i));
                }
                break;
            }
            case IMAGE: {
                float x = (this.getFileWidth(0) - this.getWatermarkImageWidth()) / 2.0f;
                float y = (this.getFileHeight(0) - this.getWatermarkImageHeight()) / 2.0f;
                this.drawImage(x, y, this.watermarkImage);
                break;
            }
            default: {
                throw new ImageWatermarkHandlerException("Unsupported watermark type.");
            }
        }
    }

    @Override
    public void drawCenterWatermark() {
        WatermarkTypeEnum watermarkType = this.getWatermarkType();
        switch (watermarkType) {
            case SINGLE_TEXT: {
                Point point = this.calcCenterWatermarkPoint(this.watermarkText, 0);
                this.drawString(point.getX(), point.getY(), this.watermarkText);
                break;
            }
            case MULTI_TEXT: {
                WatermarkBox watermarkBox = this.getWatermarkBox(watermarkType, 0);
                int watermarkListHeight = (int)watermarkBox.getHeight();
                float startY = (this.getFileHeight(0) - (float)watermarkListHeight) / 2.0f;
                if (this.watermarkConfig.getCenterLocationType() == CenterLocationTypeEnum.TOP_CENTER) {
                    startY = 0.0f;
                } else if (this.watermarkConfig.getCenterLocationType() == CenterLocationTypeEnum.BOTTOM_CENTER) {
                    startY = this.getFileHeight(0) - (float)watermarkListHeight;
                }
                for (int i = 0; i < this.watermarkTextList.size(); ++i) {
                    String curWatermarkText = (String)this.watermarkTextList.get(i);
                    Point point = this.calcCenterWatermarkPoint(curWatermarkText, 0);
                    this.drawString(point.getX(), startY + (float)i * this.getStringHeight(), curWatermarkText);
                }
                break;
            }
            case IMAGE: {
                Point point = this.calcCenterWatermarkPoint(this.watermarkBufferedImage);
                this.drawImage(point.getX(), point.getY(), this.watermarkImage);
                break;
            }
            default: {
                throw new ImageWatermarkHandlerException("Unsupported watermark type.");
            }
        }
    }

    @Override
    public void drawOverspreadWatermark() {
        float k;
        if (this.watermarkConfig.getAngle() != 0.0f) {
            if (log.isDebugEnabled()) {
                log.debug("overspread angle:{}", (Object)Float.valueOf(this.watermarkConfig.getAngle()));
            }
            this.drawOverspreadWatermarkForAngle(this.watermarkConfig.getAngle());
            return;
        }
        WatermarkBox watermarkBox = this.getWatermarkBox(this.getWatermarkType(), 0);
        OverspreadTypeEnum overspreadType = this.watermarkConfig.getOverspreadType();
        float coverage = overspreadType.getCoverage();
        float watermarkWidth = coverage * this.getFileWidth(0);
        int columns = (int)(watermarkWidth / watermarkBox.getWidth());
        float blankWidth = this.getFileWidth(0) - (float)columns * watermarkBox.getWidth();
        float widthWatermarkDistance = this.calcDistanceBetweenWatermarks(blankWidth, k = this.getFileWidth(0) * 0.01f, columns);
        float widthWatermarkDistanceFromPageBorder = widthWatermarkDistance - k;
        if (widthWatermarkDistanceFromPageBorder < 0.0f) {
            widthWatermarkDistance = this.calcDistanceBetweenWatermarks(blankWidth, k * 0.1f, columns);
            widthWatermarkDistanceFromPageBorder = (float)((double)widthWatermarkDistance - (double)k * 0.1);
        }
        float watermarkHeight = coverage * this.getFileHeight(0);
        int rows = (int)(watermarkHeight / watermarkBox.getHeight());
        float blankHeight = this.getFileHeight(0) - (float)rows * watermarkBox.getHeight();
        float heightWatermarkDistance = this.calcDistanceBetweenWatermarks(blankHeight, k, rows);
        float heightWatermarkDistanceFromPageBorder = heightWatermarkDistance - k;
        if (heightWatermarkDistanceFromPageBorder < 0.0f) {
            heightWatermarkDistance = this.calcDistanceBetweenWatermarks(blankHeight, k * 0.1f, rows);
            heightWatermarkDistanceFromPageBorder = (float)((double)heightWatermarkDistance - (double)k * 0.1);
        }
        float x = widthWatermarkDistanceFromPageBorder;
        float y = heightWatermarkDistanceFromPageBorder;
        for (int i = 0; i < columns * rows; ++i) {
            switch (this.getWatermarkType()) {
                case SINGLE_TEXT: {
                    this.drawString(x, y, this.watermarkText);
                    break;
                }
                case MULTI_TEXT: {
                    this.drawMultiLineString(x, y, this.watermarkTextList);
                    break;
                }
                case IMAGE: {
                    this.drawImage(x, y, this.watermarkImage);
                    break;
                }
                default: {
                    throw new ImageWatermarkHandlerException("Unsupported watermark type.");
                }
            }
            x += watermarkBox.getWidth() + widthWatermarkDistance;
            if (!(x > this.getFileWidth(0))) continue;
            x = widthWatermarkDistanceFromPageBorder;
            y += watermarkBox.getHeight() + heightWatermarkDistance;
        }
    }

    private void drawOverspreadWatermarkForAngle(float angle) {
        float curPageHeight;
        WatermarkBox watermarkBox = this.getWatermarkBox(this.getWatermarkType(), 0);
        OverspreadTypeEnum overspreadType = this.watermarkConfig.getOverspreadType();
        float coverage = overspreadType.getCoverage();
        float curPageWidth = this.getFileWidth(0);
        if (curPageWidth < (curPageHeight = this.getFileHeight(0))) {
            curPageWidth = curPageHeight;
        } else if (curPageHeight < curPageWidth) {
            curPageHeight = curPageWidth;
        }
        float watermarkWidth = coverage * curPageWidth;
        int columns = (int)(watermarkWidth / watermarkBox.getWidth());
        float blankWidth = curPageWidth - (float)columns * watermarkBox.getWidth();
        float k = curPageWidth * 0.01f;
        float widthWatermarkDistance = this.calcDistanceBetweenWatermarks(blankWidth, k, columns);
        float widthWatermarkDistanceFromPageBorder = widthWatermarkDistance - k;
        float watermarkHeight = coverage * curPageHeight;
        int rows = (int)(watermarkHeight / watermarkBox.getHeight());
        float blankHeight = curPageHeight - (float)rows * watermarkBox.getHeight();
        float heightWatermarkDistance = this.calcDistanceBetweenWatermarks(blankHeight, k, rows);
        float heightWatermarkDistanceFromPageBorder = heightWatermarkDistance - k;
        float newOriginX = this.getFileWidth(0) / 2.0f;
        float newOriginY = this.getFileHeight(0) / 2.0f;
        ((Graphics2D)this.graphics).rotate(Math.toRadians(angle), newOriginX, newOriginY);
        for (float x = widthWatermarkDistanceFromPageBorder - this.getFileWidth(0) / 2.0f; x < this.getFileWidth(0) * 3.0f / 2.0f; x += watermarkBox.getWidth() + widthWatermarkDistance) {
            block6: for (float y = this.getFileHeight(0) - heightWatermarkDistanceFromPageBorder - watermarkBox.getHeight() + this.getFileHeight(0) / 2.0f; y > 0.0f - this.getFileHeight(0) / 2.0f; y -= watermarkBox.getHeight() + heightWatermarkDistance) {
                switch (this.getWatermarkType()) {
                    case SINGLE_TEXT: {
                        this.drawString(x, y, this.watermarkText);
                        continue block6;
                    }
                    case MULTI_TEXT: {
                        this.drawMultiLineString(x, y, this.watermarkTextList);
                        continue block6;
                    }
                    case IMAGE: {
                        this.drawImage(x, y, this.watermarkImage);
                        continue block6;
                    }
                    default: {
                        throw new PdfWatermarkHandlerException("Unsupported watermark type.");
                    }
                }
            }
        }
    }

    private Point calcCenterWatermarkPoint(BufferedImage watermarkImage) {
        return this.calcCenterWatermarkPoint(watermarkImage.getWidth(), watermarkImage.getHeight(), 0);
    }

    @Override
    public void loadFile(byte[] data) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            this.image = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            log.error("Load image file error.", (Throwable)e);
            throw new EasyWatermarkException("Load image file error.", e);
        }
    }

    @Override
    public void close() {
        ((Graphics2D)this.graphics).dispose();
    }

    @Override
    public float getStringWidth(String text) {
        return this.fontMetrics.stringWidth(text);
    }

    @Override
    public float getStringHeight() {
        return this.fontHeight;
    }

    @Override
    public void drawString(float x, float y, String text) {
        if (log.isDebugEnabled()) {
            log.debug("Draw text. x:{},y:{},text:{}", new Object[]{Float.valueOf(x), Float.valueOf(y), text});
        }
        ((Graphics2D)this.graphics).drawString(text, x, (float)((int)((double)y + this.ascent)));
    }

    @Override
    public void drawMultiLineString(float x, float y, List<String> text) {
        if (log.isDebugEnabled()) {
            log.debug("Draw multi-line text. x:{},y:{},text:{}", new Object[]{Float.valueOf(x), Float.valueOf(y), text});
        }
        for (int i = 0; i < text.size(); ++i) {
            this.drawString(x, y + (float)i * this.getStringHeight(), text.get(i));
        }
    }

    @Override
    public void drawImage(float x, float y, byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug("Draw image. x:{},y:{}", (Object)Float.valueOf(x), (Object)Float.valueOf(y));
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(data));
            ((Graphics2D)this.graphics).drawImage((Image)bufferedImage, (int)x, (int)y, null);
        }
        catch (IOException e) {
            log.warn("Load image error.", (Throwable)e);
            throw new LoadFileException("Load image error.", e);
        }
    }
}

