/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.easywatermark.core.AbstractWatermarkHandler;
import org.easywatermark.core.EasyWatermarkCustomDraw;
import org.easywatermark.core.config.FontConfig;
import org.easywatermark.core.config.WatermarkConfig;
import org.easywatermark.core.handler.DocxWatermarkHandler;
import org.easywatermark.core.handler.ImageWatermarkHandler;
import org.easywatermark.core.handler.PdfWatermarkHandler;
import org.easywatermark.enums.EasyWatermarkTypeEnum;
import org.easywatermark.enums.FileTypeEnums;
import org.easywatermark.exception.EasyWatermarkException;
import org.easywatermark.exception.FileTypeUnsupportException;
import org.easywatermark.exception.LoadFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyWatermark {
    private static final Logger log = LoggerFactory.getLogger(EasyWatermark.class);
    private FileTypeEnums fileTypeEnums;
    private String text;
    private List<String> textList;
    private byte[] imageByte;
    private WatermarkConfig watermarkConfig = new WatermarkConfig();
    private FontConfig fontConfig = new FontConfig();
    private File file;
    private byte[] fileData;
    private EasyWatermarkTypeEnum watermarkType = EasyWatermarkTypeEnum.CENTER;
    private EasyWatermarkCustomDraw easyWatermarkCustomDraw;

    private EasyWatermark() {
    }

    public static EasyWatermark create() {
        return new EasyWatermark();
    }

    public EasyWatermark file(File file) {
        this.file = file;
        return this;
    }

    public EasyWatermark file(byte[] fileData) {
        this.fileData = fileData;
        return this;
    }

    public EasyWatermark text(String text) {
        this.cleanWatermark();
        this.text = text;
        return this;
    }

    public EasyWatermark text(List<String> textList) {
        this.cleanWatermark();
        this.textList = textList;
        return this;
    }

    public EasyWatermark text(String ... text) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, text);
        this.cleanWatermark();
        this.textList = list;
        return this;
    }

    public EasyWatermark image(byte[] imageFile) {
        if (!FileTypeEnums.isImage(imageFile)) {
            throw new LoadFileException("Image file is not support.");
        }
        this.cleanWatermark();
        this.imageByte = imageFile;
        return this;
    }

    public EasyWatermark config(WatermarkConfig watermarkConfig) {
        this.watermarkConfig = watermarkConfig;
        return this;
    }

    public EasyWatermark config(FontConfig fontConfig) {
        this.fontConfig = fontConfig;
        return this;
    }

    public EasyWatermark easyWatermarkType(EasyWatermarkTypeEnum easyWatermarkTypeEnum) {
        this.watermarkType = easyWatermarkTypeEnum;
        return this;
    }

    public EasyWatermark customDraw(EasyWatermarkCustomDraw easyWatermarkCustomDraw) {
        this.easyWatermarkCustomDraw = easyWatermarkCustomDraw;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] executor() {
        Throwable throwable;
        this.checkParam();
        if (this.file != null) {
            try {
                throwable = null;
                try (InputStream inputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
                    this.fileData = new byte[inputStream.available()];
                    inputStream.read(this.fileData);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                log.error("Load file error.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            throwable = null;
            try (AbstractWatermarkHandler<?, ?> handler = EasyWatermark.load(this.fileData, this.fontConfig, this.watermarkConfig);){
                if (this.text != null) {
                    handler.watermark(this.text);
                } else if (this.textList != null) {
                    handler.watermark(this.textList);
                } else {
                    handler.watermark(this.imageByte);
                }
                if (this.easyWatermarkCustomDraw != null) {
                    handler.setCustomDraw(this.easyWatermarkCustomDraw);
                }
                byte[] byArray = handler.execute(this.watermarkType);
                return byArray;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            log.error("Watermark error.", (Throwable)e);
            throw new EasyWatermarkException(e);
        }
    }

    private void checkParam() {
        if (this.file == null && this.fileData == null) {
            throw new LoadFileException("File and FileData is null.");
        }
        if (this.easyWatermarkCustomDraw != null) {
            return;
        }
        if (this.text == null && this.textList == null && this.imageByte == null) {
            throw new NullPointerException("Watermark text or image file is null.");
        }
        if ((this.text != null || this.textList != null) && this.imageByte != null) {
            throw new IllegalArgumentException("Watermark text and image file must not null.");
        }
    }

    private static AbstractWatermarkHandler<?, ?> load(byte[] bytes, FontConfig fontConfig, WatermarkConfig watermarkConfig) {
        AbstractWatermarkHandler handler;
        switch (FileTypeEnums.parseFileType(bytes)) {
            case PDF: {
                handler = new PdfWatermarkHandler(bytes, fontConfig, watermarkConfig);
                break;
            }
            case IMAGE: {
                handler = new ImageWatermarkHandler(bytes, fontConfig, watermarkConfig);
                break;
            }
            case OFFICE: {
                handler = new DocxWatermarkHandler(bytes, fontConfig, watermarkConfig);
                break;
            }
            default: {
                log.warn("File type not support.");
                throw new FileTypeUnsupportException("File type not support.");
            }
        }
        return handler;
    }

    private void cleanWatermark() {
        this.text = null;
        this.textList = null;
        this.imageByte = null;
    }

    public FileTypeEnums getFileTypeEnums() {
        return this.fileTypeEnums;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getTextList() {
        return this.textList;
    }

    public byte[] getImageByte() {
        return this.imageByte;
    }

    public WatermarkConfig getWatermarkConfig() {
        return this.watermarkConfig;
    }

    public FontConfig getFontConfig() {
        return this.fontConfig;
    }

    public File getFile() {
        return this.file;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public EasyWatermarkTypeEnum getWatermarkType() {
        return this.watermarkType;
    }

    public EasyWatermarkCustomDraw getEasyWatermarkCustomDraw() {
        return this.easyWatermarkCustomDraw;
    }

    public void setFileTypeEnums(FileTypeEnums fileTypeEnums) {
        this.fileTypeEnums = fileTypeEnums;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    public void setImageByte(byte[] imageByte) {
        this.imageByte = imageByte;
    }

    public void setWatermarkConfig(WatermarkConfig watermarkConfig) {
        this.watermarkConfig = watermarkConfig;
    }

    public void setFontConfig(FontConfig fontConfig) {
        this.fontConfig = fontConfig;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public void setWatermarkType(EasyWatermarkTypeEnum watermarkType) {
        this.watermarkType = watermarkType;
    }

    public void setEasyWatermarkCustomDraw(EasyWatermarkCustomDraw easyWatermarkCustomDraw) {
        this.easyWatermarkCustomDraw = easyWatermarkCustomDraw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasyWatermark)) {
            return false;
        }
        EasyWatermark other = (EasyWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileTypeEnums this$fileTypeEnums = this.getFileTypeEnums();
        FileTypeEnums other$fileTypeEnums = other.getFileTypeEnums();
        if (this$fileTypeEnums == null ? other$fileTypeEnums != null : !((Object)((Object)this$fileTypeEnums)).equals((Object)other$fileTypeEnums)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$textList = this.getTextList();
        List<String> other$textList = other.getTextList();
        if (this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList)) {
            return false;
        }
        if (!Arrays.equals(this.getImageByte(), other.getImageByte())) {
            return false;
        }
        WatermarkConfig this$watermarkConfig = this.getWatermarkConfig();
        WatermarkConfig other$watermarkConfig = other.getWatermarkConfig();
        if (this$watermarkConfig == null ? other$watermarkConfig != null : !((Object)this$watermarkConfig).equals(other$watermarkConfig)) {
            return false;
        }
        FontConfig this$fontConfig = this.getFontConfig();
        FontConfig other$fontConfig = other.getFontConfig();
        if (this$fontConfig == null ? other$fontConfig != null : !((Object)this$fontConfig).equals(other$fontConfig)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        if (!Arrays.equals(this.getFileData(), other.getFileData())) {
            return false;
        }
        EasyWatermarkTypeEnum this$watermarkType = this.getWatermarkType();
        EasyWatermarkTypeEnum other$watermarkType = other.getWatermarkType();
        if (this$watermarkType == null ? other$watermarkType != null : !((Object)((Object)this$watermarkType)).equals((Object)other$watermarkType)) {
            return false;
        }
        EasyWatermarkCustomDraw this$easyWatermarkCustomDraw = this.getEasyWatermarkCustomDraw();
        EasyWatermarkCustomDraw other$easyWatermarkCustomDraw = other.getEasyWatermarkCustomDraw();
        return !(this$easyWatermarkCustomDraw == null ? other$easyWatermarkCustomDraw != null : !this$easyWatermarkCustomDraw.equals(other$easyWatermarkCustomDraw));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EasyWatermark;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileTypeEnums $fileTypeEnums = this.getFileTypeEnums();
        result = result * 59 + ($fileTypeEnums == null ? 43 : ((Object)((Object)$fileTypeEnums)).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        result = result * 59 + Arrays.hashCode(this.getImageByte());
        WatermarkConfig $watermarkConfig = this.getWatermarkConfig();
        result = result * 59 + ($watermarkConfig == null ? 43 : ((Object)$watermarkConfig).hashCode());
        FontConfig $fontConfig = this.getFontConfig();
        result = result * 59 + ($fontConfig == null ? 43 : ((Object)$fontConfig).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        result = result * 59 + Arrays.hashCode(this.getFileData());
        EasyWatermarkTypeEnum $watermarkType = this.getWatermarkType();
        result = result * 59 + ($watermarkType == null ? 43 : ((Object)((Object)$watermarkType)).hashCode());
        EasyWatermarkCustomDraw $easyWatermarkCustomDraw = this.getEasyWatermarkCustomDraw();
        result = result * 59 + ($easyWatermarkCustomDraw == null ? 43 : $easyWatermarkCustomDraw.hashCode());
        return result;
    }

    public String toString() {
        return "EasyWatermark(fileTypeEnums=" + (Object)((Object)this.getFileTypeEnums()) + ", text=" + this.getText() + ", textList=" + this.getTextList() + ", imageByte=" + Arrays.toString(this.getImageByte()) + ", watermarkConfig=" + this.getWatermarkConfig() + ", fontConfig=" + this.getFontConfig() + ", file=" + this.getFile() + ", fileData=" + Arrays.toString(this.getFileData()) + ", watermarkType=" + (Object)((Object)this.getWatermarkType()) + ", easyWatermarkCustomDraw=" + this.getEasyWatermarkCustomDraw() + ")";
    }
}

