/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.core.handler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendMode;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.easywatermark.core.AbstractWatermarkHandler;
import org.easywatermark.core.EasyWatermarkCustomDraw;
import org.easywatermark.core.config.FontConfig;
import org.easywatermark.core.config.WatermarkConfig;
import org.easywatermark.entity.PageInfo;
import org.easywatermark.entity.Point;
import org.easywatermark.entity.WatermarkBox;
import org.easywatermark.enums.CenterLocationTypeEnum;
import org.easywatermark.enums.DiagonalDirectionTypeEnum;
import org.easywatermark.enums.EasyWatermarkTypeEnum;
import org.easywatermark.enums.FontTypeEnum;
import org.easywatermark.enums.OverspreadTypeEnum;
import org.easywatermark.enums.WatermarkTypeEnum;
import org.easywatermark.exception.ImageWatermarkHandlerException;
import org.easywatermark.exception.LoadFileException;
import org.easywatermark.exception.PdfWatermarkHandlerException;
import org.easywatermark.utils.EasyWatermarkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfWatermarkHandler
extends AbstractWatermarkHandler<PDFont, List<PDPageContentStream>> {
    private static final Logger log = LoggerFactory.getLogger(PdfWatermarkHandler.class);
    private PDDocument pdDocument;
    private PDImageXObject pdWatermarkImage;
    private float ascent;

    public PdfWatermarkHandler(byte[] data, FontConfig fontConfig, WatermarkConfig watermarkConfig) {
        super(data, fontConfig, watermarkConfig);
    }

    @Override
    protected void initGraphics() {
        int numberOfPages = this.pdDocument.getNumberOfPages();
        this.graphics = new ArrayList(numberOfPages);
        for (int i = 0; i < numberOfPages; ++i) {
            try {
                PDExtendedGraphicsState gs = new PDExtendedGraphicsState();
                gs.setNonStrokingAlphaConstant(Float.valueOf(this.watermarkConfig.getAlpha()));
                gs.setAlphaSourceFlag(true);
                gs.setBlendMode((BlendMode)BlendMode.MULTIPLY);
                PDPageContentStream contentStream = new PDPageContentStream(this.pdDocument, this.pdDocument.getPage(i), PDPageContentStream.AppendMode.APPEND, true);
                contentStream.setGraphicsStateParameters(gs);
                contentStream.setNonStrokingColor(this.watermarkConfig.getColor());
                contentStream.setFont((PDFont)this.font, (float)this.fontConfig.getFontSize());
                ((List)this.graphics).add(contentStream);
                continue;
            }
            catch (IOException e) {
                log.error("Init graphics error.", (Throwable)e);
                throw new PdfWatermarkHandlerException("Init graphics error.", e);
            }
        }
    }

    @Override
    protected void initFont() {
        File fontFile = this.fontConfig.getFontFile();
        if (fontFile == null) {
            this.font = PDType1Font.HELVETICA;
            return;
        }
        FontTypeEnum fontType = FontTypeEnum.getFontType(fontFile);
        switch (fontType) {
            case TRUE_TYPE: {
                try {
                    this.font = PDType0Font.load((PDDocument)this.pdDocument, (File)fontFile);
                    break;
                }
                catch (IOException e) {
                    log.error("Load font error.", (Throwable)e);
                    throw new LoadFileException("Load font error.", e);
                }
            }
            case TYPE1: {
                try {
                    this.font = new PDType1Font(this.pdDocument, Files.newInputStream(fontFile.toPath(), new OpenOption[0]));
                    break;
                }
                catch (IOException e) {
                    log.error("Load font error.", (Throwable)e);
                    throw new LoadFileException("Load font error.", e);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)fontType));
            }
        }
    }

    @Override
    protected void initEnvironment() {
        this.ascent = ((PDFont)this.font).getFontDescriptor().getAscent() / 1000.0f * (float)this.fontConfig.getFontSize();
        if (this.getWatermarkType() == WatermarkTypeEnum.IMAGE) {
            this.pdWatermarkImage = this.getPdImageXObject(this.watermarkImage);
        }
        if (log.isDebugEnabled()) {
            for (int i = 0; i < this.pdDocument.getNumberOfPages(); ++i) {
                log.debug("Page {} width:{}, height:{}", new Object[]{i, Float.valueOf(this.getFileWidth(i)), Float.valueOf(this.getFileHeight(i))});
            }
            log.debug("ascent:{}, string height:{}", (Object)Float.valueOf(this.ascent), (Object)Float.valueOf(this.getStringHeight()));
        }
    }

    @Override
    protected float getFileWidth(int page) {
        return this.pdDocument.getPage(page).getMediaBox().getWidth();
    }

    @Override
    protected float getFileHeight(int page) {
        return this.pdDocument.getPage(page).getMediaBox().getHeight();
    }

    @Override
    protected float getWatermarkImageWidth() {
        return this.pdWatermarkImage.getWidth();
    }

    @Override
    protected float getWatermarkImageHeight() {
        return this.pdWatermarkImage.getHeight();
    }

    @Override
    public void customDraw(EasyWatermarkCustomDraw easyWatermarkCustomDraw) {
        for (int i = 0; i < ((List)this.graphics).size(); ++i) {
            PageInfo pageInfo = new PageInfo(this.getFileWidth(i), this.getFileHeight(i), i);
            easyWatermarkCustomDraw.draw(pageInfo, this, this);
        }
    }

    @Override
    public void drawCenterWatermark() {
        WatermarkTypeEnum watermarkType = this.getWatermarkType();
        switch (watermarkType) {
            case SINGLE_TEXT: {
                for (int i = 0; i < ((List)this.graphics).size(); ++i) {
                    Point point = this.calcCenterWatermarkPoint(this.watermarkText, i);
                    this.drawString(point.getX(), point.getY(), this.watermarkText, i);
                }
                break;
            }
            case MULTI_TEXT: {
                for (int i = 0; i < ((List)this.graphics).size(); ++i) {
                    WatermarkBox watermarkBox = this.getWatermarkBox(watermarkType, i);
                    int watermarkListHeight = (int)watermarkBox.getHeight();
                    float startY = (this.getFileHeight(i) - (float)watermarkListHeight) / 2.0f;
                    if (this.watermarkConfig.getCenterLocationType() == CenterLocationTypeEnum.TOP_CENTER) {
                        startY = 0.0f;
                    } else if (this.watermarkConfig.getCenterLocationType() == CenterLocationTypeEnum.BOTTOM_CENTER) {
                        startY = this.getFileHeight(i) - (float)watermarkListHeight;
                    }
                    for (int j = 0; j < this.watermarkTextList.size(); ++j) {
                        String curWatermarkText = (String)this.watermarkTextList.get(j);
                        Point point = this.calcCenterWatermarkPoint(curWatermarkText, i);
                        this.drawString(point.getX(), startY + (float)j * this.getStringHeight(), curWatermarkText, i);
                    }
                }
                break;
            }
            case IMAGE: {
                for (int i = 0; i < ((List)this.graphics).size(); ++i) {
                    Point point = this.calcCenterWatermarkPoint(this.getWatermarkImageWidth(), this.getWatermarkImageHeight(), i);
                    this.drawImage(point.getX(), point.getY(), this.watermarkImage, i);
                }
                break;
            }
            default: {
                throw new ImageWatermarkHandlerException("Unsupported watermark type.");
            }
        }
    }

    @Override
    public void drawOverspreadWatermark() {
        if (this.watermarkConfig.getAngle() != 0.0f) {
            if (log.isDebugEnabled()) {
                log.debug("overspread angle:{}", (Object)Float.valueOf(this.watermarkConfig.getAngle()));
            }
            this.drawOverspreadWatermarkForAngle(this.watermarkConfig.getAngle());
            return;
        }
        for (int pageNumber = 0; pageNumber < ((List)this.graphics).size(); ++pageNumber) {
            this.drawOverspreadWatermark(pageNumber);
        }
    }

    @Override
    public void drawDiagonalWatermark() {
        block9: for (int i = 0; i < ((List)this.graphics).size(); ++i) {
            float fileWidth = this.getFileWidth(i);
            float fileHeight = this.getFileHeight(i);
            double radians = EasyWatermarkUtils.calcRadians(fileWidth, fileHeight);
            DiagonalDirectionTypeEnum diagonalDirectionType = this.watermarkConfig.getDiagonalDirectionType();
            switch (diagonalDirectionType) {
                case TOP_TO_BOTTOM: {
                    radians = -radians;
                    break;
                }
                case BOTTOM_TO_TOP: {
                    break;
                }
                default: {
                    throw new ImageWatermarkHandlerException("Unsupported diagonal watermark type.");
                }
            }
            PDPageContentStream pdPageContentStream = (PDPageContentStream)((List)this.graphics).get(i);
            this.rotatePageByRadians(pdPageContentStream, (float)radians, fileWidth / 2.0f, fileHeight / 2.0f);
            WatermarkTypeEnum watermarkType = this.getWatermarkType();
            switch (watermarkType) {
                case SINGLE_TEXT: {
                    this.directDrawString(-this.getStringWidth(this.watermarkText) / 2.0f, -this.getStringHeight() + this.ascent, this.watermarkText, pdPageContentStream);
                    continue block9;
                }
                case MULTI_TEXT: {
                    WatermarkBox watermarkBox = this.getWatermarkBox(watermarkType, i);
                    for (int j = 0; j < this.watermarkTextList.size(); ++j) {
                        String curWatermarkText = (String)this.watermarkTextList.get(j);
                        float tx = -this.getStringWidth(curWatermarkText) / 2.0f;
                        float ty = (watermarkBox.getHeight() + this.ascent) / 2.0f - this.getStringHeight() - (float)j * this.getStringHeight();
                        this.directDrawString(tx, ty, curWatermarkText, pdPageContentStream);
                    }
                    continue block9;
                }
                case IMAGE: {
                    this.directDrawImage(-this.getWatermarkImageWidth() / 2.0f, -this.getWatermarkImageHeight() / 2.0f, this.watermarkImage, pdPageContentStream);
                    continue block9;
                }
                default: {
                    throw new ImageWatermarkHandlerException("Unsupported watermark type.");
                }
            }
        }
    }

    @Override
    public byte[] export(EasyWatermarkTypeEnum watermarkType) {
        try {
            for (PDPageContentStream pdPageContentStream : (List)this.graphics) {
                pdPageContentStream.close();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.pdDocument.save((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            log.error("Save file error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Save file error.", e);
        }
    }

    @Override
    public void loadFile(byte[] data) {
        try {
            this.pdDocument = PDDocument.load((byte[])data);
        }
        catch (IOException e) {
            log.error("Load file error.", (Throwable)e);
            throw new LoadFileException("Load file error.", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.pdDocument.close();
    }

    @Override
    public float getStringWidth(String text) {
        try {
            return ((PDFont)this.font).getStringWidth(text) / 1000.0f * (float)this.fontConfig.getFontSize();
        }
        catch (IOException e) {
            log.error("Get string width error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Get string width error.", e);
        }
    }

    @Override
    public float getStringHeight() {
        return ((PDFont)this.font).getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)this.fontConfig.getFontSize();
    }

    @Override
    public void drawString(float x, float y, String text, int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug("Draw string in page {}, x:{}, y:{}, text:{}", new Object[]{pageNumber, Float.valueOf(x), Float.valueOf(y), text});
        }
        PDPageContentStream pdPageContentStream = (PDPageContentStream)((List)this.graphics).get(pageNumber);
        try {
            pdPageContentStream.beginText();
            pdPageContentStream.newLineAtOffset(x, this.getFileHeight(pageNumber) - y - this.ascent);
            pdPageContentStream.showText(text);
            pdPageContentStream.endText();
        }
        catch (IOException e) {
            log.error("Draw string error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Draw string error.", e);
        }
    }

    @Override
    public void drawMultiLineString(float x, float y, List<String> text, int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug("Draw multi-line string in page {}, x:{}, y:{}, text:{}", new Object[]{pageNumber, Float.valueOf(x), Float.valueOf(y), text});
        }
        PDPageContentStream pdPageContentStream = (PDPageContentStream)((List)this.graphics).get(pageNumber);
        try {
            pdPageContentStream.beginText();
            pdPageContentStream.newLineAtOffset(x, this.getFileHeight(pageNumber) - y - this.ascent);
            for (String s : text) {
                pdPageContentStream.showText(s);
                pdPageContentStream.newLineAtOffset(0.0f, -this.getStringHeight());
            }
            pdPageContentStream.endText();
        }
        catch (IOException e) {
            log.error("Draw multi-line string error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Draw multi-line string error.", e);
        }
    }

    @Override
    public void drawImage(float x, float y, byte[] data, int pageNumber) {
        PDImageXObject image = this.getPdImageXObject(data);
        if (log.isDebugEnabled()) {
            log.debug("Draw image in page {}, x:{}, y:{}", new Object[]{pageNumber, Float.valueOf(x), Float.valueOf(y)});
        }
        PDPageContentStream pdPageContentStream = (PDPageContentStream)((List)this.graphics).get(pageNumber);
        try {
            pdPageContentStream.drawImage(image, x, this.getFileHeight(pageNumber) - y - (float)image.getHeight());
        }
        catch (IOException e) {
            log.error("Draw image error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Draw image error.", e);
        }
    }

    @Override
    public void rotate(float angle, float x, float y, int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug("Rotate page {}, angle:{}, x:{}, y:{}", new Object[]{pageNumber, Float.valueOf(angle), Float.valueOf(x), Float.valueOf(y)});
        }
        PDPageContentStream pdPageContentStream = (PDPageContentStream)((List)this.graphics).get(pageNumber);
        this.rotatePage(pdPageContentStream, angle, x, y);
    }

    private void drawOverspreadWatermarkForAngle(float angle) {
        for (int i = 0; i < ((List)this.graphics).size(); ++i) {
            float curPageHeight;
            WatermarkBox watermarkBox = this.getWatermarkBox(this.getWatermarkType(), i);
            OverspreadTypeEnum overspreadType = this.watermarkConfig.getOverspreadType();
            float coverage = overspreadType.getCoverage();
            float curPageWidth = this.getFileWidth(i);
            if (curPageWidth < (curPageHeight = this.getFileHeight(i))) {
                curPageWidth = curPageHeight;
            } else if (curPageHeight < curPageWidth) {
                curPageHeight = curPageWidth;
            }
            float watermarkWidth = coverage * curPageWidth;
            int columns = (int)(watermarkWidth / watermarkBox.getWidth());
            float blankWidth = curPageWidth - (float)columns * watermarkBox.getWidth();
            float k = curPageWidth * 0.01f;
            float widthWatermarkDistance = this.calcDistanceBetweenWatermarks(blankWidth, k, columns);
            float widthWatermarkDistanceFromPageBorder = widthWatermarkDistance - k;
            float watermarkHeight = coverage * curPageHeight;
            int rows = (int)(watermarkHeight / watermarkBox.getHeight());
            float blankHeight = curPageHeight - (float)rows * watermarkBox.getHeight();
            float heightWatermarkDistance = this.calcDistanceBetweenWatermarks(blankHeight, k, rows);
            float heightWatermarkDistanceFromPageBorder = heightWatermarkDistance - k;
            PDPageContentStream pdPageContentStream = (PDPageContentStream)((List)this.graphics).get(i);
            float newOriginX = this.getFileWidth(i) / 2.0f;
            float newOriginY = this.getFileHeight(i) / 2.0f;
            this.rotatePage(pdPageContentStream, -angle, newOriginX, newOriginY);
            for (float x = widthWatermarkDistanceFromPageBorder - this.getFileWidth(i) / 2.0f; x < this.getFileWidth(i) * 3.0f / 2.0f; x += watermarkBox.getWidth() + widthWatermarkDistance) {
                block7: for (float y = this.getFileHeight(i) - heightWatermarkDistanceFromPageBorder - watermarkBox.getHeight() + this.getFileHeight(i) / 2.0f; y > 0.0f - this.getFileHeight(i) / 2.0f; y -= watermarkBox.getHeight() + heightWatermarkDistance) {
                    switch (this.getWatermarkType()) {
                        case SINGLE_TEXT: {
                            this.directDrawString(x - newOriginX, y - newOriginY, this.watermarkText, pdPageContentStream);
                            continue block7;
                        }
                        case MULTI_TEXT: {
                            this.directDrawMultiString(x - newOriginX, y - newOriginY, this.watermarkTextList, pdPageContentStream);
                            continue block7;
                        }
                        case IMAGE: {
                            this.directDrawImage(x - newOriginX, y - newOriginY, this.watermarkImage, pdPageContentStream);
                            continue block7;
                        }
                        default: {
                            throw new PdfWatermarkHandlerException("Unsupported watermark type.");
                        }
                    }
                }
            }
        }
    }

    private void rotatePage(PDPageContentStream graphics, float angle, float originX, float originY) {
        double radians = Math.toRadians(angle);
        this.rotatePageByRadians(graphics, (float)radians, originX, originY);
    }

    private void rotatePageByRadians(PDPageContentStream graphics, float radians, float originX, float originY) {
        Matrix rotateInstance = Matrix.getRotateInstance((double)radians, (float)originX, (float)originY);
        try {
            graphics.transform(rotateInstance);
        }
        catch (IOException e) {
            log.error("Rotate page error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Rotate page error.", e);
        }
    }

    private void directDrawString(float x, float y, String watermark, PDPageContentStream graphics) {
        if (log.isDebugEnabled()) {
            log.debug("Draw string x:{}, y:{}, text:{}", new Object[]{Float.valueOf(x), Float.valueOf(y), watermark});
        }
        try {
            graphics.beginText();
            graphics.newLineAtOffset(x, y);
            graphics.showText(watermark);
            graphics.endText();
        }
        catch (IOException e) {
            log.error("Draw string error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Draw string error.", e);
        }
    }

    private void directDrawMultiString(float x, float y, List<String> watermark, PDPageContentStream graphics) {
        if (log.isDebugEnabled()) {
            log.debug("Draw multi-line string x:{}, y:{}, text:{}", new Object[]{Float.valueOf(x), Float.valueOf(y), watermark});
        }
        try {
            graphics.beginText();
            graphics.newLineAtOffset(x, y);
            for (String s : watermark) {
                graphics.showText(s);
                graphics.newLineAtOffset(0.0f, -this.getStringHeight());
            }
            graphics.endText();
        }
        catch (IOException e) {
            log.error("Draw multi-line string error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Draw multi-line string error.", e);
        }
    }

    private void directDrawImage(float x, float y, byte[] data, PDPageContentStream graphics) {
        PDImageXObject image = this.getPdImageXObject(data);
        if (log.isDebugEnabled()) {
            log.debug("Draw image x:{}, y:{}", (Object)Float.valueOf(x), (Object)Float.valueOf(y));
        }
        try {
            graphics.drawImage(image, x, y);
        }
        catch (IOException e) {
            log.error("Draw image error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Draw image error.", e);
        }
    }

    private PDImageXObject getPdImageXObject(byte[] data) {
        try {
            return PDImageXObject.createFromByteArray((PDDocument)this.pdDocument, (byte[])data, (String)"image");
        }
        catch (IOException e) {
            log.error("Create image error.", (Throwable)e);
            throw new PdfWatermarkHandlerException("Create image error.", e);
        }
    }
}

