/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.utils;

import java.awt.Color;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.CTPosH;
import org.docx4j.dml.wordprocessingDrawing.CTPosV;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.dml.wordprocessingDrawing.STRelFromH;
import org.docx4j.dml.wordprocessingDrawing.STRelFromV;
import org.docx4j.vml.CTFill;
import org.docx4j.vml.CTShape;
import org.docx4j.vml.CTStroke;
import org.docx4j.vml.CTTextPath;
import org.docx4j.vml.STExt;
import org.docx4j.vml.officedrawing.CTLock;
import org.docx4j.vml.officedrawing.STTrueFalse;
import org.docx4j.vml.wordprocessingDrawing.CTWrap;
import org.docx4j.vml.wordprocessingDrawing.ObjectFactory;
import org.docx4j.wml.Pict;
import org.docx4j.wml.R;
import org.easywatermark.utils.EasyWatermarkUtils;

public class DocxUtils {
    private static final String SHAPE_SPID = "_x0000_s2049";
    private static final String SHAPE_TYPE = "#_x0000_t136";
    private static final String TEXT_PATH_FONT_NAME = "font-family:\"%s\";";

    public static CTTextPath createNormalTextPath(String watermark, String fontName) {
        CTTextPath res = new CTTextPath();
        res.setStyle(String.format("v-text-align:left;font-family:\"%s\";", fontName));
        res.setString(watermark);
        return res;
    }

    public static CTTextPath createCenterTextPath(String watermark, String fontName) {
        CTTextPath res = new CTTextPath();
        res.setStyle(String.format("v-text-align:center;font-family:\"%s\";", fontName));
        res.setString(watermark);
        return res;
    }

    public static CTShape createNormalShape(Color color) {
        CTShape res = new CTShape();
        res.setFillcolor(EasyWatermarkUtils.hexColor(color));
        res.setVmlId("easy-watermark framework");
        res.setStroked(org.docx4j.vml.STTrueFalse.F);
        res.setSpid(SHAPE_SPID);
        res.setType(SHAPE_TYPE);
        return res;
    }

    public static R createR(CTTextPath textPath, CTShape ctShape, float alpha) {
        CTFill ctFill = new CTFill();
        ctFill.setOn(org.docx4j.vml.STTrueFalse.T);
        ctFill.setOpacity(String.valueOf(alpha));
        JAXBElement<CTFill> fill = DocxUtils.createJAXBElement(ctFill);
        CTStroke ctStroke = new CTStroke();
        ctStroke.setOn(org.docx4j.vml.STTrueFalse.F);
        JAXBElement<CTStroke> stroke = DocxUtils.createJAXBElement(ctStroke);
        CTLock ctLock = new CTLock();
        ctLock.setExt(STExt.VIEW);
        ctLock.setAspectratio(STTrueFalse.T);
        JAXBElement<CTLock> lock = DocxUtils.createJAXBElement(ctLock);
        JAXBElement<CTTextPath> textpath = DocxUtils.createJAXBElement(textPath);
        List egShapeElements = ctShape.getEGShapeElements();
        egShapeElements.add(fill);
        egShapeElements.add(stroke);
        egShapeElements.add(lock);
        egShapeElements.add(textpath);
        JAXBElement<CTShape> shape = DocxUtils.createJAXBElement(ctShape);
        Pict pict = new Pict();
        pict.getAnyAndAny().add(shape);
        R r = new R();
        JAXBElement<Pict> rPict = DocxUtils.createJAXBElement(pict);
        r.getContent().add(rPict);
        return r;
    }

    public static Anchor createAnchorByInline(Inline imageInline, float x, float y) {
        Anchor anchor = new Anchor();
        CTPosH ctPosH = new CTPosH();
        ctPosH.setRelativeFrom(STRelFromH.MARGIN);
        ctPosH.setPosOffset(Integer.valueOf((int)x * 12700));
        CTPosV ctPosV = new CTPosV();
        ctPosV.setRelativeFrom(STRelFromV.MARGIN);
        ctPosV.setPosOffset(Integer.valueOf((int)y * 12700));
        anchor.setPositionH(ctPosH);
        anchor.setPositionV(ctPosV);
        anchor.setExtent(imageInline.getExtent());
        anchor.setEffectExtent(imageInline.getEffectExtent());
        anchor.setDocPr(imageInline.getDocPr());
        anchor.setCNvGraphicFramePr(imageInline.getCNvGraphicFramePr());
        anchor.setGraphic(imageInline.getGraphic());
        return anchor;
    }

    public static <T> JAXBElement<T> createJAXBElement(T value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        org.docx4j.wml.ObjectFactory wmlObjectFactory = new org.docx4j.wml.ObjectFactory();
        org.docx4j.vml.ObjectFactory vmlObjectFactory = new org.docx4j.vml.ObjectFactory();
        ObjectFactory wpdObjectFactory = new ObjectFactory();
        org.docx4j.vml.officedrawing.ObjectFactory odObjectFactory = new org.docx4j.vml.officedrawing.ObjectFactory();
        Class<?> clazz = value.getClass();
        if (clazz == Pict.class) {
            return wmlObjectFactory.createRPict((Pict)value);
        }
        if (clazz == CTShape.class) {
            return vmlObjectFactory.createShape((CTShape)value);
        }
        if (clazz == CTWrap.class) {
            return wpdObjectFactory.createWrap((CTWrap)value);
        }
        if (clazz == CTFill.class) {
            return vmlObjectFactory.createFill((CTFill)value);
        }
        if (clazz == CTStroke.class) {
            return vmlObjectFactory.createStroke((CTStroke)value);
        }
        if (clazz == CTLock.class) {
            return odObjectFactory.createLock((CTLock)value);
        }
        if (clazz == CTTextPath.class) {
            return vmlObjectFactory.createTextpath((CTTextPath)value);
        }
        throw new UnsupportedOperationException("Unsupported value type: " + clazz.getName());
    }
}

