/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CompareTo<T extends Comparable<T>>
extends TypeSafeMatcher<T> {
    @Nonnull
    private static final Comparator<Comparable> GREATER_THAN_COMPARATOR = (actual, exp) -> actual.compareTo(exp) > 0;
    @Nonnull
    private static final Comparator<Comparable> GREATER_THAN_OR_EQUAL_TO_COMPARATOR = (actual, exp) -> actual.compareTo(exp) >= 0;
    @Nonnull
    private static final Comparator<Comparable> LESS_THAN_COMPARATOR = (actual, exp) -> actual.compareTo(exp) < 0;
    @Nonnull
    private static final Comparator<Comparable> LESS_THAN_OR_EQUAL_TO_COMPARATOR = (actual, exp) -> actual.compareTo(exp) <= 0;
    @Nonnull
    private final T expected;
    @Nonnull
    private final String comparatorDescription;
    @Nonnull
    private final Comparator<T> comparator;

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> isGreaterThan(@Nonnull T expected) {
        return new CompareTo<T>(expected, "is greater than", CompareTo.greaterThanComparator());
    }

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> isGreaterThanOrEqualTo(@Nonnull T expected) {
        return new CompareTo<T>(expected, "is greater than or equal to", CompareTo.greaterThanOrEqualToComparator());
    }

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> isLessThan(@Nonnull T expected) {
        return new CompareTo<T>(expected, "is less than", CompareTo.lessThanComparator());
    }

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> isLessThanOrEqualTo(@Nonnull T expected) {
        return new CompareTo<T>(expected, "is less than or equal to", CompareTo.lessThanOrEqualToComparator());
    }

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> greaterThan(@Nonnull T expected) {
        return CompareTo.isGreaterThan(expected);
    }

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> greaterThanOrEqualTo(@Nonnull T expected) {
        return CompareTo.isGreaterThanOrEqualTo(expected);
    }

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> lessThan(@Nonnull T expected) {
        return CompareTo.isLessThan(expected);
    }

    @Nonnull
    public static <T extends Comparable<T>> Matcher<T> lessThanOrEqualTo(@Nonnull T expected) {
        return CompareTo.isLessThanOrEqualTo(expected);
    }

    @Nonnull
    protected static <T extends Comparable<T>> Comparator<T> greaterThanComparator() {
        return GREATER_THAN_COMPARATOR;
    }

    @Nonnull
    protected static <T extends Comparable<T>> Comparator<T> greaterThanOrEqualToComparator() {
        return GREATER_THAN_OR_EQUAL_TO_COMPARATOR;
    }

    @Nonnull
    protected static <T extends Comparable<T>> Comparator<T> lessThanComparator() {
        return LESS_THAN_COMPARATOR;
    }

    @Nonnull
    protected static <T extends Comparable<T>> Comparator<T> lessThanOrEqualToComparator() {
        return LESS_THAN_OR_EQUAL_TO_COMPARATOR;
    }

    protected CompareTo(@Nonnull T expected, @Nonnull String comparatorDescription, @Nonnull Comparator<T> comparator) {
        super(CompareTo.typeOf(expected));
        this.expected = expected;
        this.comparatorDescription = comparatorDescription;
        this.comparator = comparator;
    }

    protected boolean matchesSafely(T item) {
        return this.comparator.check(item, this.expected);
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText(this.comparatorDescription).appendText(" ").appendValue(this.expected);
    }

    @Nonnull
    protected T expected() {
        return this.expected;
    }

    @Nonnull
    protected String comparatorDescription() {
        return this.comparatorDescription;
    }

    @Nonnull
    protected Comparator<T> comparator() {
        return this.comparator;
    }

    @Nonnull
    protected static Class<?> typeOf(@Nonnull Object expected) {
        if (expected == null) {
            throw new NullPointerException("The provided expected value is null.");
        }
        if (!(expected instanceof Comparable)) {
            throw new IllegalArgumentException("The provided expected value is not of type " + Comparable.class.getName() + ".");
        }
        return expected.getClass();
    }

    @FunctionalInterface
    public static interface Comparator<T extends Comparable> {
        public boolean check(@Nonnull T var1, @Nonnull T var2);
    }
}

