/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.unittest.utils.utils.SizeUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HasSize<T>
extends BaseMatcher<T> {
    @Nonnegative
    private final long expectedSize;
    @Nonnull
    private final Map<Object, Long> itemToSize = Collections.synchronizedMap(new WeakHashMap(1, 1.0f));

    @Nonnull
    public static <T> Matcher<T> hasSize(@Nonnegative long size) {
        return new HasSize<T>(size);
    }

    @Nonnull
    public static <T> Matcher<T> hasSizeOf(@Nonnegative long size) {
        return HasSize.hasSize(size);
    }

    @Nonnull
    public static <T> Matcher<T> hasLength(@Nonnegative long size) {
        return HasSize.hasSize(size);
    }

    @Nonnull
    public static <T> Matcher<T> hasLengthOf(@Nonnegative long size) {
        return HasSize.hasSize(size);
    }

    protected HasSize(@Nonnegative long expectedSize) {
        this.expectedSize = expectedSize;
    }

    public boolean matches(@Nullable Object item) {
        long size = this.itemToSize.computeIfAbsent(item, SizeUtils::sizeOf);
        return size == this.expectedSize;
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText("has size of ").appendValue((Object)this.expectedSize);
    }

    public void describeMismatch(@Nullable Object item, @Nonnull Description description) {
        description.appendText("was ").appendValue((Object)this.itemToSize.get(item)).appendText(" with content ").appendValue(item);
    }
}

