/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.rules;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class TemporaryDirectoryBasedRuleSupport<T extends TemporaryDirectoryBasedRuleSupport<T>>
implements TestRule {
    @Nullable
    private Path baseDirectory;
    private boolean failOnProblemsWhileCleanup = true;

    public boolean isFailOnProblemsWhileCleanup() {
        return this.failOnProblemsWhileCleanup;
    }

    @Nonnull
    public T setFailOnProblemsWhileCleanup(boolean failOnProblemsWhileCleanup) {
        this.failOnProblemsWhileCleanup = failOnProblemsWhileCleanup;
        return (T)this;
    }

    public Statement apply(final @Nonnull Statement base, final @Nonnull Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TemporaryDirectoryBasedRuleSupport.this.evaluate(base, description);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluate(@Nonnull Statement base, @Nonnull Description description) throws Throwable {
        Path baseDirectory;
        this.baseDirectory = baseDirectory = this.generateTemporaryFolderFor(description);
        try {
            this.evaluate(base, description, baseDirectory);
        }
        finally {
            this.baseDirectory = null;
            this.deleteDirectory(baseDirectory);
        }
    }

    protected abstract void evaluate(@Nonnull Statement var1, @Nonnull Description var2, @Nonnull Path var3) throws Throwable;

    @Nonnull
    protected Path baseDirectory() {
        return Objects.requireNonNull(this.baseDirectory, "Method was not called within test evaluation or @Rule/@ClassRule was missing at field.");
    }

    @Nonnull
    protected Path generateTemporaryFolderFor(@Nonnull Description description) throws Exception {
        String name = this.folderNameFor(description);
        return Files.createTempDirectory(name + "-", new FileAttribute[0]);
    }

    @Nonnull
    protected String folderNameFor(@Nonnull Description description) {
        return this.normalizeFolderName(description.getDisplayName());
    }

    @Nonnull
    protected String normalizeFolderName(@Nonnull String input) {
        char[] inputCharacters = input.toCharArray();
        char[] result = new char[inputCharacters.length];
        for (int i = 0; i < inputCharacters.length; ++i) {
            int c = inputCharacters[i];
            result[i] = Character.isLetterOrDigit((char)c) || c == 46 || c == 44 || c == 95 || c == 45 || c == 64 || c == 37 || c == 126 || c == 40 || c == 41 || c == 91 || c == 93 || c == 33 ? c : 95;
        }
        return new String(result);
    }

    protected void deleteDirectory(@Nonnull Path what) throws Exception {
        try {
            Files.walkFileTree(what, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        TemporaryDirectoryBasedRuleSupport.this.handleExceptionIfRequired(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        TemporaryDirectoryBasedRuleSupport.this.handleExceptionIfRequired(exc);
                    } else {
                        try {
                            Files.delete(dir);
                        }
                        catch (IOException e) {
                            TemporaryDirectoryBasedRuleSupport.this.handleExceptionIfRequired(e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.handleExceptionIfRequired(e);
        }
    }

    protected void handleExceptionIfRequired(@Nonnull IOException e) throws IOException {
        if (this.isFailOnProblemsWhileCleanup()) {
            throw e;
        }
    }
}

