/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public final class StringUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static boolean isEmpty(@Nullable String what) {
        return what == null || what.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable String what) {
        return !StringUtils.isEmpty(what);
    }

    public static boolean hasContent(@Nullable String what) {
        return StringUtils.isNotEmpty(what);
    }

    @Nonnull
    public static String toString(@Nullable Object what) {
        if (what == null) {
            return "";
        }
        if (what instanceof String) {
            return (String)what;
        }
        if (what instanceof char[]) {
            return StringUtils.toString((char[])what);
        }
        if (what instanceof byte[]) {
            return StringUtils.toString((byte[])what);
        }
        if (what instanceof Reader) {
            return StringUtils.toString((Reader)what);
        }
        if (what instanceof InputStream) {
            return StringUtils.toString((InputStream)what);
        }
        if (what instanceof URL) {
            return StringUtils.toString((URL)what);
        }
        if (what instanceof Path) {
            return StringUtils.toString((Path)what);
        }
        if (what instanceof File) {
            return StringUtils.toString((File)what);
        }
        return what.toString();
    }

    @Nonnull
    public static String toString(@Nullable @WillNotClose Reader what) {
        if (what == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            char[] buf = new char[4096];
            int read = what.read(buf);
            while (read >= 0) {
                result.append(buf, 0, read);
                read = what.read(buf);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return result.toString();
    }

    @Nonnull
    public static String toString(@Nullable @WillNotClose InputStream what) {
        return StringUtils.toString(what != null ? new InputStreamReader(what, UTF8) : null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static String toString(@Nullable URL what) {
        if (what == null) {
            return "";
        }
        try (InputStream is = what.openStream();){
            String string = StringUtils.toString(is);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static String toString(@Nullable Path what) {
        if (what == null) {
            return "";
        }
        try (InputStream is = Files.newInputStream(what, new OpenOption[0]);){
            String string = StringUtils.toString(is);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nonnull
    public static String toString(@Nullable File what) {
        if (what == null) {
            return "";
        }
        return StringUtils.toString(what.toPath());
    }

    @Nonnull
    public static String toString(@Nullable char[] what) {
        if (what == null) {
            return "";
        }
        return new String(what);
    }

    @Nonnull
    public static String toString(@Nullable byte[] what) {
        if (what == null) {
            return "";
        }
        return new String(what, UTF8);
    }
}

