/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.unittest.utils.matchers.StreamBasedMatcherSupport;
import org.echocat.unittest.utils.utils.StreamUtils;
import org.hamcrest.Matcher;

public class ContainsAtLeastOneElementThat<V, T>
extends StreamBasedMatcherSupport<V, T> {
    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return Iterables.containsAtLeastOneElementThat(matcher, otherMatchers);
    }

    protected ContainsAtLeastOneElementThat(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Matcher<T> firstMatcher, @Nullable Matcher<T>[] otherMatchers) {
        super(mapper, firstMatcher, otherMatchers);
    }

    protected ContainsAtLeastOneElementThat(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Iterable<Matcher<T>> matchers) {
        super(mapper, matchers);
    }

    @Override
    protected boolean matches(@Nonnull Stream<T> items) {
        AtomicBoolean atLeastOneRowMatches = new AtomicBoolean(false);
        items.forEach(item -> {
            AtomicBoolean allMatchersMatches = new AtomicBoolean(true);
            this.matchers().forEach(matcher -> {
                if (!matcher.matches(item)) {
                    allMatchersMatches.set(false);
                }
            });
            if (allMatchersMatches.get()) {
                atLeastOneRowMatches.set(true);
            }
        });
        return atLeastOneRowMatches.get();
    }

    @Override
    protected String description() {
        return "contains at least one element that";
    }

    public static interface Arrays {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<T[]> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsAtLeastOneElementThat<Object[], T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Spliterators {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Spliterator<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsAtLeastOneElementThat<Spliterator, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Iterators {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Iterator<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsAtLeastOneElementThat<Iterator, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Iterables {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Iterable<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsAtLeastOneElementThat<Iterable, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }

    public static interface Streams {
        @SafeVarargs
        @Nonnull
        public static <T> Matcher<Stream<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
            return new ContainsAtLeastOneElementThat<Stream, T>(StreamUtils::toStream, matcher, otherMatchers);
        }
    }
}

