/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class IsOneOf<T>
extends BaseMatcher<T> {
    @Nonnull
    private final Collection<T> expected;

    @Nonnull
    public static <T> Matcher<T> isOneOf(@Nonnull Collection<T> expected) {
        return new IsOneOf<T>(expected);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T> isOneOf(@Nonnull T firstExpected, T ... others) {
        HashSet<T> them = new HashSet<T>();
        them.add(firstExpected);
        if (others != null) {
            them.addAll(Arrays.asList(others));
        }
        return IsOneOf.isOneOf(them);
    }

    protected IsOneOf(@Nonnull Collection<T> expected) {
        if (expected.isEmpty()) {
            throw new IllegalArgumentException("There is no expected item provided.");
        }
        this.expected = expected;
    }

    public boolean matches(@Nullable Object item) {
        return this.expected.contains(item);
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText("is one of ").appendValue(this.expected);
    }

    public void describeMismatch(@Nullable Object item, @Nonnull Description description) {
        description.appendText("was ").appendValue(item);
    }
}

