/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.unittest.utils.nio.WrappedFileSystem;
import org.echocat.unittest.utils.nio.WrappedPath;

public class WrappedFileSystemProvider<T extends WrappedPath>
extends FileSystemProvider {
    @Nonnull
    private final Class<T> wrappedPathType;
    @Nonnull
    private final FileSystemProvider wrapped;

    protected WrappedFileSystemProvider(@Nonnull Class<T> wrappedPathType, @Nonnull FileSystemProvider wrapped) {
        this.wrappedPathType = wrappedPathType;
        this.wrapped = wrapped;
    }

    @Nonnull
    public FileSystemProvider wrapped() {
        return this.wrapped;
    }

    @Nonnull
    protected Path unwrap(@Nullable Path plain) {
        if (plain == null) {
            throw new NullPointerException("No path provided.");
        }
        if (!this.wrappedPathType.isInstance(plain)) {
            throw new IllegalArgumentException("Could only handle paths of type '" + this.wrappedPathType.getName() + "' but got an instance of type '" + plain.getClass().getName() + "'.");
        }
        return ((WrappedPath)this.wrappedPathType.cast(plain)).wrapped();
    }

    @Override
    public String getScheme() {
        return this.wrapped().getScheme();
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return new WrappedFileSystem<T>(this.wrappedPathType, this.wrapped().newFileSystem(uri, env));
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return new WrappedFileSystem<T>(this.wrappedPathType, this.wrapped().getFileSystem(uri));
    }

    @Override
    public Path getPath(URI uri) {
        return this.wrapped().getPath(uri);
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        return this.wrapped().newFileSystem(this.unwrap(path), env);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return this.wrapped().newInputStream(this.unwrap(path), options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return this.wrapped().newOutputStream(this.unwrap(path), options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?>[] attrs) throws IOException {
        return this.wrapped().newFileChannel(this.unwrap(path), options, attrs);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?>[] attrs) throws IOException {
        return this.wrapped().newAsynchronousFileChannel(this.unwrap(path), options, executor, attrs);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?>[] attrs) throws IOException {
        return this.wrapped().newByteChannel(this.unwrap(path), options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.wrapped().newDirectoryStream(this.unwrap(dir), filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?>[] attrs) throws IOException {
        this.wrapped().createDirectory(this.unwrap(dir), attrs);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?>[] attrs) throws IOException {
        this.wrapped().createSymbolicLink(this.unwrap(link), this.unwrap(target), attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        this.wrapped().createLink(this.unwrap(link), this.unwrap(existing));
    }

    @Override
    public void delete(Path path) throws IOException {
        this.wrapped().delete(this.unwrap(path));
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return this.wrapped().deleteIfExists(this.unwrap(path));
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return this.wrapped().readSymbolicLink(this.unwrap(link));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.wrapped().copy(this.unwrap(source), this.unwrap(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.wrapped().move(this.unwrap(source), this.unwrap(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.wrapped().isSameFile(this.unwrap(path), this.unwrap(path2));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.wrapped().isHidden(this.unwrap(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.wrapped().getFileStore(this.unwrap(path));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.wrapped().checkAccess(this.unwrap(path), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.wrapped().getFileAttributeView(this.unwrap(path), type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.wrapped().readAttributes(this.unwrap(path), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.wrapped().readAttributes(this.unwrap(path), attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.wrapped().setAttribute(this.unwrap(path), attribute, value, options);
    }
}

