/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.echocat.unittest.utils.matchers.CombinedMappingMatcher;
import org.echocat.unittest.utils.matchers.ContainsAtLeastOneElementThat;
import org.echocat.unittest.utils.matchers.ContainsOnlyElementsThat;
import org.echocat.unittest.utils.utils.StreamUtils;
import org.hamcrest.Matcher;

public interface IteratorMatchers {
    @Nonnull
    public static <T> Matcher<Iterator<T>> containsOnlyElementsThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsOnlyElementsThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterator<T>> containsOnlyElementsThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IteratorMatchers.containsOnlyElementsThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Iterator<T>> containsOnlyElements(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return IteratorMatchers.containsOnlyElementsThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterator<T>> containsOnlyElements(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IteratorMatchers.containsOnlyElements(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Iterator<T>> containsAtLeastOneElementThat(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return new ContainsAtLeastOneElementThat(StreamUtils::toStream, matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterator<T>> containsAtLeastOneElementThat(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IteratorMatchers.containsAtLeastOneElementThat(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }

    @Nonnull
    public static <T> Matcher<Iterator<T>> containsAtLeastOneElement(@Nonnull Iterable<? extends Matcher<T>> matchers) {
        return IteratorMatchers.containsAtLeastOneElementThat(matchers);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterator<T>> containsAtLeastOneElement(@Nonnull Matcher<T> matcher, Matcher<T> ... otherMatchers) {
        return IteratorMatchers.containsAtLeastOneElement(CombinedMappingMatcher.collectMatchers(matcher, otherMatchers));
    }
}

