/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class StringBasedMatcher<T extends CharSequence>
extends BaseMatcher<T> {
    @Nonnull
    private final String expected;
    @Nonnull
    private final String comparatorDescription;
    @Nonnull
    private final Comparator comparator;

    @Nonnull
    protected static Comparator startsWithComparator() {
        return String::startsWith;
    }

    @Nonnull
    protected static Comparator endsWithComparator() {
        return String::endsWith;
    }

    @Nonnull
    protected static Comparator containsComparator() {
        return String::contains;
    }

    @Nonnull
    protected static Comparator matchesComparator() {
        return String::matches;
    }

    @Nonnull
    protected static Comparator equalsIgnoreCaseComparator() {
        return String::equalsIgnoreCase;
    }

    protected StringBasedMatcher(@Nonnull String comparatorDescription, @Nonnull Comparator comparator, @Nonnull String expected) {
        this.comparatorDescription = comparatorDescription;
        this.comparator = comparator;
        this.expected = expected;
    }

    public boolean matches(@Nullable Object item) {
        if (item instanceof CharSequence) {
            return this.comparator.check(item.toString(), this.expected);
        }
        return false;
    }

    public void describeTo(@Nonnull Description description) {
        description.appendText(this.comparatorDescription).appendText(" ").appendValue((Object)this.expected);
    }

    @Nonnull
    protected String expected() {
        return this.expected;
    }

    @Nonnull
    protected String comparatorDescription() {
        return this.comparatorDescription;
    }

    @Nonnull
    protected Comparator comparator() {
        return this.comparator;
    }

    @FunctionalInterface
    public static interface Comparator {
        public boolean check(@Nonnull String var1, @Nonnull String var2);
    }
}

