/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SizeUtils {
    @Nonnegative
    public static long sizeOf(@Nullable Object what) {
        if (what == null) {
            return 0L;
        }
        if (what instanceof Stream) {
            return ((Stream)what).count();
        }
        if (what instanceof Path) {
            return SizeUtils.sizeOf((Path)what);
        }
        if (what instanceof Collection) {
            return ((Collection)what).size();
        }
        if (what instanceof Iterable) {
            return SizeUtils.sizeOf(((Iterable)what).iterator());
        }
        if (what instanceof Iterator) {
            return SizeUtils.sizeOf((Iterator)what);
        }
        if (what instanceof Map) {
            return ((Map)what).size();
        }
        if (what instanceof Object[]) {
            return ((Object[])what).length;
        }
        if (what instanceof boolean[]) {
            return ((boolean[])what).length;
        }
        if (what instanceof byte[]) {
            return ((byte[])what).length;
        }
        if (what instanceof char[]) {
            return ((char[])what).length;
        }
        if (what instanceof short[]) {
            return ((short[])what).length;
        }
        if (what instanceof int[]) {
            return ((int[])what).length;
        }
        if (what instanceof long[]) {
            return ((long[])what).length;
        }
        if (what instanceof float[]) {
            return ((float[])what).length;
        }
        if (what instanceof double[]) {
            return ((double[])what).length;
        }
        if (what instanceof CharSequence) {
            return ((CharSequence)what).length();
        }
        if (what instanceof File) {
            return SizeUtils.sizeOf(((File)what).toPath());
        }
        if (what instanceof InputStream) {
            return SizeUtils.sizeOf((InputStream)what);
        }
        if (what instanceof Reader) {
            return SizeUtils.sizeOf((Reader)what);
        }
        if (what instanceof URL) {
            return SizeUtils.sizeOf((URL)what);
        }
        if (what instanceof URI) {
            return SizeUtils.sizeOf((URI)what);
        }
        throw new IllegalArgumentException("Could not get size of " + what.getClass().getName() + ".");
    }

    @Nonnegative
    private static long sizeOf(@Nonnull Iterator<?> iterator) {
        long result = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    @Nonnegative
    private static long sizeOf(@Nonnull Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nonnegative
    private static long sizeOf(@Nonnull InputStream is) {
        long nread = 0L;
        byte[] buf = new byte[8192];
        try {
            int n;
            while ((n = is.read(buf)) > 0) {
                nread += (long)n;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return nread;
    }

    @Nonnegative
    private static long sizeOf(@Nonnull Reader reader) {
        long nread = 0L;
        char[] buf = new char[8192];
        try {
            int n;
            while ((n = reader.read(buf)) > 0) {
                nread += (long)n;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return nread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnegative
    private static long sizeOf(@Nonnull URL url) {
        try (InputStream is = url.openStream();){
            long l = SizeUtils.sizeOf(is);
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nonnegative
    private static long sizeOf(@Nonnull URI uri) {
        try {
            return SizeUtils.sizeOf(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isNotEmpty(@Nullable Object what) {
        return !SizeUtils.isEmpty(what);
    }

    public static boolean isEmpty(@Nullable Object what) {
        if (what == null) {
            return true;
        }
        if (what instanceof Stream) {
            return ((Stream)what).count() == 0L;
        }
        if (what instanceof Path) {
            return SizeUtils.sizeOf((Path)what) == 0L;
        }
        if (what instanceof Collection) {
            return ((Collection)what).isEmpty();
        }
        if (what instanceof Iterable) {
            return SizeUtils.isEmpty(((Iterable)what).iterator());
        }
        if (what instanceof Iterator) {
            return SizeUtils.isEmpty((Iterator)what);
        }
        if (what instanceof Map) {
            return ((Map)what).isEmpty();
        }
        if (what instanceof File) {
            return SizeUtils.sizeOf(((File)what).toPath()) == 0L;
        }
        return SizeUtils.sizeOf(what) == 0L;
    }

    @Nonnegative
    private static boolean isEmpty(@Nonnull Iterator<?> iterator) {
        return !iterator.hasNext();
    }
}

