/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.unittest.utils.matchers;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.echocat.unittest.utils.matchers.CombinedMappingMatcher;
import org.hamcrest.Matcher;

public class ContainsAtLeastOneElementThat<V, T>
extends CombinedMappingMatcher<V, T> {
    public ContainsAtLeastOneElementThat(@Nonnull Function<V, Stream<T>> mapper, @Nonnull Iterable<? extends Matcher<T>> matchers) {
        super(mapper, matchers, ContainsAtLeastOneElementThat.streamMatcherInstance(), "contains at least one element that");
    }

    @Nonnull
    protected static <T> CombinedMappingMatcher.StreamMatcher<T> streamMatcherInstance() {
        return ContainsAtLeastOneElementThat::matches;
    }

    protected static <T> boolean matches(@Nonnull Iterable<? extends Matcher<T>> matchers, @Nonnull Stream<T> items) {
        AtomicBoolean atLeastOneRowMatches = new AtomicBoolean(false);
        items.forEach(item -> {
            AtomicBoolean allMatchersMatches = new AtomicBoolean(true);
            matchers.forEach(matcher -> {
                if (!matcher.matches(item)) {
                    allMatchersMatches.set(false);
                }
            });
            if (allMatchersMatches.get()) {
                atLeastOneRowMatches.set(true);
            }
        });
        return atLeastOneRowMatches.get();
    }
}

